/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.internal.LoadingCollectionEntryImpl;
import org.hibernate.sql.results.internal.domain.collection.EagerCollectionAssembler;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CollectionInitializer;
import org.hibernate.sql.results.spi.CollectionResultNode;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.FetchableContainer;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.LoadContexts;
import org.hibernate.sql.results.spi.LoadingCollectionEntry;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class CollectionDomainResult
implements DomainResult,
CollectionResultNode,
FetchParent {
    private final NavigablePath loadingPath;
    private final PluralAttributeMapping loadingAttribute;
    private final String resultVariable;
    private final DomainResult fkResult;
    private final CollectionInitializerProducer initializerProducer;

    public CollectionDomainResult(NavigablePath loadingPath, PluralAttributeMapping loadingAttribute, String resultVariable, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.loadingPath = loadingPath;
        this.loadingAttribute = loadingAttribute;
        this.resultVariable = resultVariable;
        this.fkResult = loadingAttribute.getKeyDescriptor().createDomainResult(loadingPath, tableGroup, creationState);
        CollectionSemantics collectionSemantics = loadingAttribute.getCollectionDescriptor().getCollectionSemantics();
        this.initializerProducer = collectionSemantics.createInitializerProducer(loadingPath, loadingAttribute, this, true, null, LockMode.READ, creationState);
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.loadingAttribute.getJavaTypeDescriptor();
    }

    public DomainResultAssembler createResultAssembler(Consumer initializerCollector, AssemblerCreationState creationState) {
        DomainResultAssembler fkAssembler = this.fkResult.createResultAssembler(initializerCollector, creationState);
        CollectionInitializer initializer = this.initializerProducer.produceInitializer(this.loadingPath, this.loadingAttribute, null, LockMode.READ, fkAssembler, fkAssembler, initializerCollector, creationState);
        initializerCollector.accept(initializer);
        return new EagerCollectionAssembler(this.loadingAttribute, initializer);
    }

    @Override
    public FetchableContainer getReferencedMappingContainer() {
        return this.loadingAttribute;
    }

    @Override
    public FetchableContainer getReferencedMappingType() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.loadingPath;
    }

    @Override
    public List<Fetch> getFetches() {
        return null;
    }

    @Override
    public Fetch findFetch(String fetchableName) {
        return null;
    }

    private static class InitializerImpl
    implements CollectionInitializer {
        private final NavigablePath loadingPath;
        private final PluralAttributeMapping loadingCollection;
        private final DomainResultAssembler fkAssembler;
        private final DomainResultAssembler elementAssembler;
        private final DomainResultAssembler indexAssembler;
        private final DomainResultAssembler identifierAssembler;
        private CollectionKey collectionKey;
        private boolean managing;
        private Object fkValue;
        private PersistentCollection instance;

        public InitializerImpl(NavigablePath loadingPath, PluralAttributeMapping loadingCollection, DomainResult fkResult, Fetch elementFetch, Fetch indexFetch, DomainResult identifierResult, Consumer<Initializer> collector, AssemblerCreationState creationState) {
            this.loadingPath = loadingPath;
            this.loadingCollection = loadingCollection;
            this.fkAssembler = fkResult.createResultAssembler(collector, creationState);
            this.elementAssembler = elementFetch.createAssembler(null, collector, creationState);
            this.indexAssembler = indexFetch == null ? null : indexFetch.createAssembler(null, collector, creationState);
            this.identifierAssembler = identifierResult == null ? null : identifierResult.createResultAssembler(collector, creationState);
        }

        @Override
        public PluralAttributeMapping getInitializedPart() {
            return this.loadingCollection;
        }

        @Override
        public PersistentCollection getCollectionInstance() {
            return this.instance;
        }

        @Override
        public NavigablePath getNavigablePath() {
            return this.loadingPath;
        }

        @Override
        public void finishUpRow(RowProcessingState rowProcessingState) {
            this.collectionKey = null;
            this.managing = false;
            this.instance = null;
        }

        @Override
        public void resolveKey(RowProcessingState rowProcessingState) {
            if (this.collectionKey != null) {
                return;
            }
            Object fkValue = this.fkAssembler.assemble(rowProcessingState);
            assert (fkValue != null);
            this.collectionKey = new CollectionKey(this.loadingCollection.getCollectionDescriptor(), fkValue);
        }

        @Override
        public void resolveInstance(RowProcessingState rowProcessingState) {
            if (this.instance != null) {
                return;
            }
            PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContext();
            LoadContexts loadContexts = persistenceContext.getLoadContexts();
            LoadingCollectionEntry existingEntry = loadContexts.findLoadingCollectionEntry(this.collectionKey);
            if (existingEntry != null) {
                this.instance = existingEntry.getCollectionInstance();
                if (existingEntry.getInitializer() == this) {
                    this.managing = true;
                }
                return;
            }
            PersistentCollection registeredInstance = persistenceContext.getCollection(this.collectionKey);
            if (registeredInstance != null) {
                this.instance = registeredInstance;
                if (!registeredInstance.wasInitialized()) {
                    this.managing = true;
                    rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingCollection(this.collectionKey, new LoadingCollectionEntryImpl(this.getInitializingCollectionDescriptor(), this, this.collectionKey, registeredInstance));
                    return;
                }
            }
            this.instance = InitializerImpl.makePersistentCollection(this.loadingCollection, this.collectionKey, rowProcessingState);
            this.managing = true;
            rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingCollection(this.collectionKey, new LoadingCollectionEntryImpl(this.loadingCollection.getCollectionDescriptor(), this, this.collectionKey.getKey(), this.instance));
        }

        private static PersistentCollection makePersistentCollection(PluralAttributeMapping fetchedMapping, CollectionKey collectionKey, RowProcessingState rowProcessingState) {
            CollectionPersister collectionDescriptor = fetchedMapping.getCollectionDescriptor();
            CollectionSemantics collectionSemantics = collectionDescriptor.getCollectionSemantics();
            return collectionSemantics.instantiateWrapper(collectionKey.getKey(), collectionDescriptor, rowProcessingState.getSession());
        }

        @Override
        public void initializeInstance(RowProcessingState rowProcessingState) {
            if (!this.managing) {
                return;
            }
            Object fkValue = this.fkAssembler.assemble(rowProcessingState);
            if (fkValue == null) {
                return;
            }
            PersistentCollection collectionInstance = this.getCollectionInstance();
            collectionInstance.readFrom(rowProcessingState, this.elementAssembler, this.indexAssembler, this.identifierAssembler, collectionInstance.getOwner());
        }
    }
}

