/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import java.util.function.Consumer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CollectionInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.LoadingCollectionEntry;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class DelayedCollectionAssembler
implements DomainResultAssembler {
    private final PluralAttributeMapping fetchedMapping;
    private final FetchParentAccess parentAccess;
    private final CollectionInitializer initializer;

    public DelayedCollectionAssembler(NavigablePath fetchPath, PluralAttributeMapping fetchedMapping, FetchParentAccess parentAccess, Consumer<Initializer> collector, AssemblerCreationState creationState) {
        this.fetchedMapping = fetchedMapping;
        this.parentAccess = parentAccess;
        this.initializer = new InitializerImpl(fetchPath, fetchedMapping, parentAccess, creationState);
        collector.accept(this.initializer);
    }

    public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        return this.initializer.getCollectionInstance();
    }

    public JavaTypeDescriptor getAssembledJavaTypeDescriptor() {
        return this.fetchedMapping.getJavaTypeDescriptor();
    }

    private static class InitializerImpl
    implements CollectionInitializer {
        private final NavigablePath fetchedPath;
        private final PluralAttributeMapping fetchedMapping;
        private final FetchParentAccess parentAccess;
        private CollectionKey collectionKey;
        private PersistentCollection instance;

        public InitializerImpl(NavigablePath fetchedPath, PluralAttributeMapping fetchedMapping, FetchParentAccess parentAccess, AssemblerCreationState creationState) {
            this.fetchedPath = fetchedPath;
            this.fetchedMapping = fetchedMapping;
            this.parentAccess = parentAccess;
        }

        @Override
        public NavigablePath getNavigablePath() {
            return this.fetchedPath;
        }

        @Override
        public void resolveKey(RowProcessingState rowProcessingState) {
            if (this.collectionKey != null) {
                return;
            }
            this.collectionKey = new CollectionKey(this.fetchedMapping.getCollectionDescriptor(), this.parentAccess.getParentKey());
        }

        @Override
        public void resolveInstance(RowProcessingState rowProcessingState) {
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            PersistenceContext persistenceContext = session.getPersistenceContext();
            LoadingCollectionEntry loadingEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(this.collectionKey);
            PersistentCollection registeredInstance = persistenceContext.getCollection(this.collectionKey);
            if (loadingEntry != null) {
                this.instance = loadingEntry.getCollectionInstance();
                return;
            }
            if (registeredInstance != null) {
                this.instance = registeredInstance;
                return;
            }
            this.instance = InitializerImpl.makePersistentCollection(this.fetchedMapping, this.collectionKey, rowProcessingState);
            persistenceContext.addUninitializedCollection(this.getInitializingCollectionDescriptor(), this.instance, this.collectionKey.getKey());
        }

        private static PersistentCollection makePersistentCollection(PluralAttributeMapping fetchedMapping, CollectionKey collectionKey, RowProcessingState rowProcessingState) {
            CollectionPersister collectionDescriptor = fetchedMapping.getCollectionDescriptor();
            CollectionSemantics collectionSemantics = collectionDescriptor.getCollectionSemantics();
            return collectionSemantics.instantiateWrapper(collectionKey.getKey(), collectionDescriptor, rowProcessingState.getSession());
        }

        @Override
        public void initializeInstance(RowProcessingState rowProcessingState) {
        }

        @Override
        public void finishUpRow(RowProcessingState rowProcessingState) {
            this.collectionKey = null;
            this.instance = null;
        }

        @Override
        public PluralAttributeMapping getInitializedPart() {
            return this.fetchedMapping;
        }

        @Override
        public PersistentCollection getCollectionInstance() {
            return this.instance;
        }
    }
}

