/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.internal.domain.collection.CollectionFetch;
import org.hibernate.sql.results.internal.domain.collection.EagerCollectionAssembler;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CollectionInitializer;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.FetchableContainer;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class EagerCollectionFetch
extends CollectionFetch
implements FetchParent {
    private final DomainResult keyContainerResult;
    private final DomainResult keyCollectionResult;
    private final Fetch elementFetch;
    private final Fetch indexFetch;
    private final List<Fetch> fetches;
    private final CollectionInitializerProducer initializerProducer;

    public EagerCollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, boolean nullable, FetchParent fetchParent, DomainResultCreationState creationState) {
        super(fetchedPath, fetchedAttribute, nullable, fetchParent);
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        TableGroup collectionTableGroup = fromClauseAccess.getTableGroup(fetchedPath);
        NavigablePath parentPath = fetchedPath.getParent();
        TableGroup parentTableGroup = parentPath == null ? null : fromClauseAccess.findTableGroup(parentPath);
        ForeignKeyDescriptor keyDescriptor = fetchedAttribute.getKeyDescriptor();
        if (parentTableGroup != null) {
            this.keyContainerResult = keyDescriptor.createDomainResult(fetchedPath, parentTableGroup, creationState);
            this.keyCollectionResult = keyDescriptor.createDomainResult(fetchedPath, collectionTableGroup, creationState);
        } else {
            this.keyContainerResult = keyDescriptor.createDomainResult(fetchedPath, collectionTableGroup, creationState);
            this.keyCollectionResult = null;
        }
        this.fetches = creationState.visitFetches(this);
        if (fetchedAttribute.getIndexDescriptor() != null) {
            assert (this.fetches.size() == 2);
            this.indexFetch = this.fetches.get(0);
            this.elementFetch = this.fetches.get(1);
        } else {
            assert (this.fetches.size() == 1);
            this.indexFetch = null;
            this.elementFetch = this.fetches.get(0);
        }
        CollectionSemantics collectionSemantics = this.getFetchedMapping().getCollectionDescriptor().getCollectionSemantics();
        this.initializerProducer = collectionSemantics.createInitializerProducer(fetchedPath, fetchedAttribute, fetchParent, nullable, null, LockMode.READ, creationState);
    }

    @Override
    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, Consumer<Initializer> collector, AssemblerCreationState creationState) {
        DomainResultAssembler keyContainerAssembler = this.keyContainerResult.createResultAssembler(collector, creationState);
        DomainResultAssembler keyCollectionAssembler = this.keyCollectionResult == null ? null : this.keyCollectionResult.createResultAssembler(collector, creationState);
        CollectionInitializer initializer = this.initializerProducer.produceInitializer(this.getNavigablePath(), this.getFetchedMapping(), parentAccess, null, keyContainerAssembler, keyCollectionAssembler, collector, creationState);
        collector.accept(initializer);
        return new EagerCollectionAssembler(this.getFetchedMapping(), initializer);
    }

    @Override
    public FetchableContainer getReferencedMappingContainer() {
        return this.getFetchedMapping();
    }

    @Override
    public PluralAttributeMapping getReferencedMappingType() {
        return this.getFetchedMapping();
    }

    @Override
    public List<Fetch> getFetches() {
        return this.fetches;
    }

    @Override
    public Fetch findFetch(String fetchableName) {
        if (CollectionPart.Nature.ELEMENT.getName().equals(fetchableName)) {
            return this.elementFetch;
        }
        if (CollectionPart.Nature.INDEX.getName().equals(fetchableName)) {
            return this.indexFetch;
        }
        throw new IllegalArgumentException("Unknown fetchable [" + this.getFetchedMapping().getCollectionDescriptor().getRole() + " -> " + fetchableName + "]");
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.getFetchedMapping().getJavaTypeDescriptor();
    }
}

