/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import org.hibernate.LockMode;
import org.hibernate.collection.internal.PersistentList;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.RowProcessingState;

public class ListInitializer
extends AbstractImmediateCollectionInitializer {
    private final DomainResultAssembler listIndexAssembler;
    private final DomainResultAssembler elementAssembler;
    private final int listIndexBase;

    public ListInitializer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParentAccess parentAccess, boolean selected, LockMode lockMode, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler, DomainResultAssembler listIndexAssembler, DomainResultAssembler elementAssembler) {
        super(navigablePath, attributeMapping, parentAccess, selected, lockMode, keyContainerAssembler, keyCollectionAssembler);
        this.listIndexAssembler = listIndexAssembler;
        this.elementAssembler = elementAssembler;
        this.listIndexBase = attributeMapping.getIndexMetadata().getListIndexBase();
    }

    @Override
    public PersistentList getCollectionInstance() {
        return (PersistentList)super.getCollectionInstance();
    }

    @Override
    protected void readCollectionRow(RowProcessingState rowProcessingState) {
        int index = (Integer)this.listIndexAssembler.assemble(rowProcessingState);
        this.getCollectionAttributeMapping().getIndexMetadata().getIndexDescriptor();
        if (this.listIndexBase != 0) {
            index -= this.listIndexBase;
        }
        this.getCollectionInstance().load(index, this.elementAssembler.assemble(rowProcessingState));
    }

    public String toString() {
        return "ListInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

