/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import org.hibernate.LockMode;
import org.hibernate.collection.internal.PersistentMap;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.RowProcessingState;

public class MapInitializer
extends AbstractImmediateCollectionInitializer {
    private final DomainResultAssembler mapKeyAssembler;
    private final DomainResultAssembler mapValueAssembler;

    public MapInitializer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParentAccess parentAccess, boolean selected, LockMode lockMode, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler, DomainResultAssembler mapKeyAssembler, DomainResultAssembler mapValueAssembler) {
        super(navigablePath, attributeMapping, parentAccess, selected, lockMode, keyContainerAssembler, keyCollectionAssembler);
        this.mapKeyAssembler = mapKeyAssembler;
        this.mapValueAssembler = mapValueAssembler;
    }

    @Override
    public PersistentMap getCollectionInstance() {
        return (PersistentMap)super.getCollectionInstance();
    }

    @Override
    protected void readCollectionRow(RowProcessingState rowProcessingState) {
        this.getCollectionInstance().load(this.mapKeyAssembler.assemble(rowProcessingState), this.mapValueAssembler.assemble(rowProcessingState));
    }

    public String toString() {
        return "MapInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

