/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.MapInitializer;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CollectionInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;

public class MapInitializerProducer
implements CollectionInitializerProducer {
    private final PluralAttributeMapping mapDescriptor;
    private final boolean isJoined;
    private final Fetch mapKeyFetch;
    private final Fetch mapValueFetch;

    public MapInitializerProducer(PluralAttributeMapping mapDescriptor, boolean isJoined, Fetch mapKeyFetch, Fetch mapValueFetch) {
        this.mapDescriptor = mapDescriptor;
        this.isJoined = isJoined;
        this.mapKeyFetch = mapKeyFetch;
        this.mapValueFetch = mapValueFetch;
    }

    @Override
    public CollectionInitializer produceInitializer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParentAccess parentAccess, LockMode lockMode, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler, Consumer<Initializer> initializerConsumer, AssemblerCreationState creationState) {
        DomainResultAssembler mapKeyAssembler = this.mapKeyFetch.createAssembler(parentAccess, initializerConsumer, creationState);
        DomainResultAssembler mapValueAssembler = this.mapValueFetch.createAssembler(parentAccess, initializerConsumer, creationState);
        return new MapInitializer(navigablePath, this.mapDescriptor, parentAccess, this.isJoined, lockMode, keyContainerAssembler, keyCollectionAssembler, mapKeyAssembler, mapValueAssembler);
    }
}

