/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.composite;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.internal.domain.AbstractFetchParentAccess;
import org.hibernate.sql.results.internal.domain.composite.CompositeLoadingLogger;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CompositeInitializer;
import org.hibernate.sql.results.spi.CompositeResultNode;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.RowProcessingState;

public abstract class AbstractCompositeInitializer
extends AbstractFetchParentAccess
implements CompositeInitializer {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart embeddedModelPartDescriptor;
    private final FetchParentAccess fetchParentAccess;
    private final Map<StateArrayContributorMapping, DomainResultAssembler> assemblerMap;
    private final Object[] resolvedValues;
    private Object compositeInstance;

    public AbstractCompositeInitializer(CompositeResultNode resultDescriptor, FetchParentAccess fetchParentAccess, Consumer<Initializer> initializerConsumer, AssemblerCreationState creationState) {
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embeddedModelPartDescriptor = resultDescriptor.getReferencedMappingContainer();
        this.fetchParentAccess = fetchParentAccess;
        int numOfAttrs = this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
        this.resolvedValues = new Object[numOfAttrs];
        this.assemblerMap = new IdentityHashMap<StateArrayContributorMapping, DomainResultAssembler>(numOfAttrs);
        this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor().visitStateArrayContributors(stateArrayContributor -> {
            Fetch fetch = resultDescriptor.findFetch(stateArrayContributor.getFetchableName());
            DomainResultAssembler stateAssembler = fetch == null ? new NullValueAssembler(stateArrayContributor.getJavaTypeDescriptor()) : fetch.createAssembler(this, initializerConsumer, creationState);
            this.assemblerMap.put((StateArrayContributorMapping)stateArrayContributor, stateAssembler);
        });
    }

    @Override
    public EmbeddableValuedModelPart getInitializedPart() {
        return this.embeddedModelPartDescriptor;
    }

    public FetchParentAccess getFetchParentAccess() {
        return this.fetchParentAccess;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public Object getCompositeInstance() {
        return this.compositeInstance;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        SingularAttributeMapping parentInjectionTarget = this.embeddedModelPartDescriptor.getParentInjectionAttributeMapping();
        if (parentInjectionTarget != null) {
            this.getFetchParentAccess().findFirstEntityDescriptorAccess().registerResolutionListener(owner -> {
                if (this.compositeInstance == null) {
                    return;
                }
                parentInjectionTarget.getPropertyAccess().getSetter().set(this.compositeInstance, owner, rowProcessingState.getSession().getFactory());
            });
        }
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        this.compositeInstance = this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator().instantiate(rowProcessingState.getSession());
        CompositeLoadingLogger.INSTANCE.debugf("Created composite instance [%s] : %s", this.navigablePath, this.compositeInstance);
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        CompositeLoadingLogger.INSTANCE.debugf("Initializing composite instance [%s] : %s", this.navigablePath, this.compositeInstance);
        for (Map.Entry<StateArrayContributorMapping, DomainResultAssembler> entry : this.assemblerMap.entrySet()) {
            Object contributorValue = entry.getValue().assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
            this.resolvedValues[entry.getKey().getStateArrayPosition()] = contributorValue;
        }
        this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor().setPropertyValues(this.compositeInstance, this.resolvedValues);
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.compositeInstance = null;
        this.clearParentResolutionListeners();
    }

    @Override
    public FetchParentAccess findFirstEntityDescriptorAccess() {
        return this.getFetchParentAccess().findFirstEntityDescriptorAccess();
    }
}

