/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.composite;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.internal.domain.AbstractFetchParent;
import org.hibernate.sql.results.internal.domain.composite.CompositeAssembler;
import org.hibernate.sql.results.internal.domain.composite.CompositeRootInitializer;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CompositeResultNode;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class CompositeResult<T>
extends AbstractFetchParent
implements CompositeResultNode,
DomainResult<T> {
    private final String resultVariable;

    public CompositeResult(NavigablePath navigablePath, EmbeddableValuedModelPart modelPart, String resultVariable, DomainResultCreationState creationState) {
        super(modelPart.getEmbeddableTypeDescriptor(), navigablePath);
        this.resultVariable = resultVariable;
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        fromClauseAccess.resolveTableGroup(navigablePath, np -> {
            EmbeddableValuedModelPart embeddedValueMapping = modelPart.getEmbeddableTypeDescriptor().getEmbeddedValueMapping();
            TableGroupJoin tableGroupJoin = embeddedValueMapping.createTableGroupJoin(navigablePath, fromClauseAccess.findTableGroup(navigablePath.getParent()), resultVariable, JoinType.INNER, LockMode.NONE, creationState.getSqlAstCreationState().getSqlAliasBaseGenerator(), creationState.getSqlAstCreationState().getSqlExpressionResolver(), creationState.getSqlAstCreationState().getCreationContext());
            return tableGroupJoin.getJoinedGroup();
        });
        this.afterInitialize(creationState);
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return (EmbeddableMappingType)super.getFetchContainer();
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.getReferencedMappingType().getJavaTypeDescriptor();
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.getFetchContainer();
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(Consumer<Initializer> initializerCollector, AssemblerCreationState creationState) {
        CompositeRootInitializer initializer = new CompositeRootInitializer(this, initializerCollector, creationState);
        initializerCollector.accept(initializer);
        return new CompositeAssembler(initializer);
    }
}

