/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.entity.EntityAssembler;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.EntityInitializer;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Fetchable;
import org.hibernate.sql.results.spi.Initializer;

public abstract class AbstractEntityFetch
implements Fetch {
    private final FetchParent fetchParent;
    private final Fetchable fetchedAttribute;
    private final NavigablePath navigablePath;
    private final boolean nullable;
    private final LockMode lockMode;

    public AbstractEntityFetch(FetchParent fetchParent, Fetchable fetchedAttribute, NavigablePath navigablePath, boolean nullable, LockMode lockMode) {
        this.fetchParent = fetchParent;
        this.fetchedAttribute = fetchedAttribute;
        this.navigablePath = navigablePath;
        this.nullable = nullable;
        this.lockMode = lockMode;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.fetchedAttribute;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, Consumer<Initializer> collector, AssemblerCreationState creationState) {
        EntityInitializer entityInitializer = this.getEntityInitializer(parentAccess, collector, creationState);
        collector.accept(entityInitializer);
        return new EntityAssembler(this.getFetchedMapping().getJavaTypeDescriptor(), entityInitializer);
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    protected abstract EntityInitializer getEntityInitializer(FetchParentAccess var1, Consumer<Initializer> var2, AssemblerCreationState var3);
}

