/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.WrongClassException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.internal.domain.AbstractFetchParentAccess;
import org.hibernate.sql.results.internal.domain.entity.EntityLoadingLogger;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.EntityInitializer;
import org.hibernate.sql.results.spi.EntityResultNode;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.LoadingEntityEntry;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.TypeHelper;

public abstract class AbstractEntityInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final EntityPersister entityDescriptor;
    private final EntityPersister rootEntityDescriptor;
    private final NavigablePath navigablePath;
    private final LockMode lockMode;
    private final List<Initializer> identifierInitializers = new ArrayList<Initializer>();
    private final DomainResultAssembler identifierAssembler;
    private final DomainResultAssembler discriminatorAssembler;
    private final DomainResultAssembler versionAssembler;
    private final Map<AttributeMapping, DomainResultAssembler> assemblerMap;
    private EntityPersister concreteDescriptor;
    private EntityKey entityKey;
    private Object entityInstance;
    private boolean missing;
    private Object[] resolvedEntityState;

    protected AbstractEntityInitializer(EntityResultNode resultDescriptor, NavigablePath navigablePath, LockMode lockMode, DomainResult<?> identifierResult, DomainResult<?> discriminatorResult, DomainResult<?> versionResult, Consumer<Initializer> initializerConsumer, AssemblerCreationState creationState) {
        this.entityDescriptor = (EntityPersister)resultDescriptor.getEntityValuedModelPart().getEntityMappingType();
        String rootEntityName = this.entityDescriptor.getRootEntityName();
        this.rootEntityDescriptor = rootEntityName == null || rootEntityName.equals(this.entityDescriptor.getEntityName()) ? this.entityDescriptor : creationState.getSqlAstCreationContext().getDomainModel().findEntityDescriptor(rootEntityName);
        this.navigablePath = navigablePath;
        this.lockMode = lockMode;
        this.identifierAssembler = identifierResult.createResultAssembler(this.identifierInitializers::add, creationState);
        this.discriminatorAssembler = discriminatorResult != null ? discriminatorResult.createResultAssembler(initializer -> {
            throw new UnsupportedOperationException("Registering an Initializer as part of Entity discriminator is illegal");
        }, creationState) : null;
        this.versionAssembler = versionResult != null ? versionResult.createResultAssembler(initializer -> {
            throw new UnsupportedOperationException("Registering an Initializer as part of Entity version is illegal");
        }, creationState) : null;
        this.assemblerMap = new IdentityHashMap<AttributeMapping, DomainResultAssembler>(this.entityDescriptor.getNumberOfAttributeMappings());
        this.entityDescriptor.visitFetchables(fetchable -> {
            AttributeMapping attributeMapping = (AttributeMapping)((Object)fetchable);
            Fetch fetch = resultDescriptor.findFetch(fetchable.getFetchableName());
            DomainResultAssembler stateAssembler = fetch == null ? new NullValueAssembler(attributeMapping.getMappedTypeDescriptor().getMappedJavaTypeDescriptor()) : fetch.createAssembler(this, initializerConsumer, creationState);
            this.assemblerMap.put(attributeMapping, stateAssembler);
        }, null);
        initializerConsumer.accept(this);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    protected abstract boolean isEntityReturn();

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    public Object getKeyValue() {
        return this.entityKey.getIdentifier();
    }

    @Override
    public Object getParentKey() {
        return this.getKeyValue();
    }

    @Override
    public Object getFetchParentInstance() {
        if (this.entityInstance == null) {
            throw new IllegalStateException("Unexpected state condition - entity instance not yet resolved");
        }
        return this.entityInstance;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.entityInstance != null) {
            return;
        }
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.INSTANCE.tracef("(%s) Beginning Initializer#resolveKey process for entity : %s", StringHelper.collapse(this.getClass().getName()), this.getNavigablePath().getFullPath());
        }
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        this.concreteDescriptor = this.determineConcreteEntityDescriptor(rowProcessingState, session);
        this.initializeIdentifier(rowProcessingState);
        this.resolveEntityKey(rowProcessingState);
        if (this.entityKey == null) {
            EntityLoadingLogger.INSTANCE.debugf("(%s) EntityKey (%s) is null", StringHelper.collapse(this.getClass().getName()), this.getNavigablePath());
            assert (this.missing);
            return;
        }
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.INSTANCE.debugf("(%s) Hydrated EntityKey (%s): %s", StringHelper.collapse(this.getClass().getName()), this.getNavigablePath(), this.entityKey.getIdentifier());
        }
    }

    private EntityPersister determineConcreteEntityDescriptor(RowProcessingState rowProcessingState, SharedSessionContractImplementor session) throws WrongClassException {
        if (this.discriminatorAssembler == null) {
            return this.entityDescriptor;
        }
        Object discriminatorValue = this.discriminatorAssembler.assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
        String concreteEntityName = ((Loadable)this.entityDescriptor).getSubclassForDiscriminatorValue(discriminatorValue);
        if (concreteEntityName == null) {
            throw new WrongClassException("Discriminator: " + discriminatorValue, this.entityKey.getIdentifier(), this.entityDescriptor.getEntityName());
        }
        EntityPersister concreteType = session.getFactory().getMetamodel().findEntityDescriptor(concreteEntityName);
        assert (concreteType.isTypeOrSuperType(this.entityDescriptor));
        return concreteType;
    }

    protected void initializeIdentifier(RowProcessingState rowProcessingState) {
        this.identifierInitializers.forEach(initializer -> initializer.resolveKey(rowProcessingState));
        this.identifierInitializers.forEach(initializer -> initializer.resolveInstance(rowProcessingState));
        this.identifierInitializers.forEach(initializer -> initializer.initializeInstance(rowProcessingState));
    }

    protected void resolveEntityKey(RowProcessingState rowProcessingState) {
        if (this.entityKey != null) {
            return;
        }
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        Object id = this.identifierAssembler.assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
        if (id == null) {
            this.missing = true;
            return;
        }
        this.entityKey = new EntityKey(id, this.concreteDescriptor);
        if (this.concreteDescriptor.isBatchLoadable() && !session.getPersistenceContext().containsEntity(this.entityKey)) {
            session.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(this.entityKey);
        }
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        Object entity;
        Serializable requestedEntityId;
        SharedSessionContractImplementor session;
        LoadingEntityEntry existingLoadingEntry;
        if (this.missing) {
            return;
        }
        Serializable entityIdentifier = this.entityKey.getIdentifier();
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.INSTANCE.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", StringHelper.collapse(this.getClass().getName()), this.getNavigablePath(), entityIdentifier);
        }
        if ((existingLoadingEntry = (session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession()).getPersistenceContext().getLoadContexts().findLoadingEntityEntry(this.entityKey)) != null) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.INSTANCE.debugf("(%s) Found existing loading entry [%s] - using loading instance", StringHelper.collapse(this.getClass().getName()), LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier));
            }
            this.entityInstance = existingLoadingEntry.getEntityInstance();
            if (existingLoadingEntry.getEntityInitializer() != this) {
                if (EntityLoadingLogger.DEBUG_ENABLED) {
                    EntityLoadingLogger.INSTANCE.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", StringHelper.collapse(this.getClass().getName()), LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier), existingLoadingEntry.getEntityInitializer());
                }
                return;
            }
        }
        if (this.entityInstance == null && this.isEntityReturn() && (requestedEntityId = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalId()) != null && requestedEntityId.equals(this.entityKey.getIdentifier())) {
            this.entityInstance = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject();
        }
        if (this.entityInstance == null && (entity = session.getPersistenceContext().getEntity(this.entityKey)) != null) {
            this.entityInstance = entity;
        }
        if (this.entityInstance == null) {
            this.entityInstance = session.instantiate(this.concreteDescriptor.getEntityName(), this.entityKey.getIdentifier());
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.INSTANCE.debugf("Created new entity instance [%s] : %s", LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier), this.entityInstance);
            }
            LoadingEntityEntry loadingEntry = new LoadingEntityEntry(this, this.entityKey, this.concreteDescriptor, this.entityInstance);
            rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingEntity(this.entityKey, loadingEntry);
        }
        this.notifyParentResolutionListeners(this.entityInstance);
        this.preLoad(rowProcessingState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        Status status;
        SharedSessionContractImplementor session;
        PersistenceContext persistenceContext;
        if (this.missing) {
            return;
        }
        Serializable entityIdentifier = this.entityKey.getIdentifier();
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.INSTANCE.tracef("Beginning Initializer#initializeInstance process for entity %s", LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier));
        }
        if ((persistenceContext = (session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession()).getPersistenceContext()).containsEntity(this.entityKey) && ((status = persistenceContext.getEntry(persistenceContext.getEntity(this.entityKey)).getStatus()) == Status.DELETED || status == Status.GONE)) {
            return;
        }
        Object rowId = null;
        this.entityDescriptor.setIdentifier(this.entityInstance, entityIdentifier, session);
        this.resolvedEntityState = this.concreteDescriptor.extractConcreteTypeStateValues(this.assemblerMap, rowProcessingState);
        this.concreteDescriptor.setPropertyValues(this.entityInstance, this.resolvedEntityState);
        persistenceContext.addEntity(this.entityKey, this.entityInstance);
        Object version = this.versionAssembler != null ? this.versionAssembler.assemble(rowProcessingState) : null;
        EntityEntry entityEntry = persistenceContext.addEntry(this.entityInstance, Status.LOADING, this.resolvedEntityState, rowId, this.entityKey.getIdentifier(), version, this.lockMode, true, this.concreteDescriptor, false);
        SessionFactoryImplementor factory = session.getFactory();
        EntityDataAccess cacheAccess = this.concreteDescriptor.getCacheAccessStrategy();
        if (cacheAccess != null && session.getCacheMode().isPutEnabled()) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.INSTANCE.debugf("Adding entityInstance to second-level cache: %s", LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier));
            }
            CacheEntry entry = this.concreteDescriptor.buildCacheEntry(this.entityInstance, this.resolvedEntityState, version, session);
            Object cacheKey = cacheAccess.generateCacheKey(entityIdentifier, this.rootEntityDescriptor, factory, session.getTenantIdentifier());
            if (persistenceContext.wasInsertedDuringTransaction(this.concreteDescriptor, entityIdentifier)) {
                cacheAccess.update(session, cacheKey, this.rootEntityDescriptor.getCacheEntryStructure().structure(entry), version, version);
            } else {
                SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
                try {
                    eventListenerManager.cachePutStart();
                    boolean put = cacheAccess.putFromLoad(session, cacheKey, this.rootEntityDescriptor.getCacheEntryStructure().structure(entry), version, false);
                    if (put && factory.getStatistics().isStatisticsEnabled()) {
                        factory.getStatistics().entityCachePut(this.rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                    }
                }
                finally {
                    eventListenerManager.cachePutEnd();
                }
            }
        }
        if (this.entityDescriptor.getNaturalIdMapping() != null) {
            persistenceContext.getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(this.entityDescriptor, entityIdentifier, persistenceContext.getNaturalIdHelper().extractNaturalIdValues(this.resolvedEntityState, this.entityDescriptor));
        }
        boolean isReallyReadOnly = this.isReadOnly(rowProcessingState, session);
        if (!this.concreteDescriptor.isMutable()) {
            isReallyReadOnly = true;
        } else {
            Object proxy = persistenceContext.getProxy(this.entityKey);
            if (proxy != null) {
                isReallyReadOnly = ((HibernateProxy)proxy).getHibernateLazyInitializer().isReadOnly();
            }
        }
        if (isReallyReadOnly) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            TypeHelper.deepCopy(this.concreteDescriptor, this.resolvedEntityState, this.resolvedEntityState, attributeMapping -> attributeMapping.getAttributeMetadataAccess().resolveAttributeMetadata(this.concreteDescriptor).isUpdatable());
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        this.concreteDescriptor.afterInitialize(this.entityInstance, session);
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.INSTANCE.debugf("Done materializing entityInstance : %s", LoggingHelper.toLoggableString(this.getNavigablePath(), (Object)entityIdentifier));
        }
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatistics().loadEntity(this.concreteDescriptor.getEntityName());
        }
        this.postLoad(rowProcessingState);
    }

    private boolean isReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor persistenceContext) {
        if (persistenceContext.isDefaultReadOnly()) {
            return true;
        }
        Boolean queryOption = rowProcessingState.getJdbcValuesSourceProcessingState().getQueryOptions().isReadOnly();
        return queryOption == null ? false : queryOption;
    }

    private void preLoad(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        if (session instanceof EventSource) {
            PreLoadEvent preLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPreLoadEvent();
            assert (preLoadEvent != null);
            preLoadEvent.reset();
            preLoadEvent.setEntity(this.entityInstance).setId(this.entityKey.getIdentifier()).setPersister(this.concreteDescriptor);
            EventListenerGroup<PreLoadEventListener> listenerGroup = session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.PRE_LOAD);
            for (PreLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPreLoad(preLoadEvent);
            }
        }
    }

    private void postLoad(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        if (session instanceof EventSource) {
            PostLoadEvent postLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPostLoadEvent();
            assert (postLoadEvent != null);
            postLoadEvent.reset();
            postLoadEvent.setEntity(this.entityInstance).setId(this.entityKey.getIdentifier()).setPersister(this.concreteDescriptor);
            EventListenerGroup<PostLoadEventListener> listenerGroup = this.entityDescriptor.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.POST_LOAD);
            for (PostLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPostLoad(postLoadEvent);
            }
        }
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.concreteDescriptor = null;
        this.entityKey = null;
        this.entityInstance = null;
        this.missing = false;
        this.resolvedEntityState = null;
        this.clearParentResolutionListeners();
    }
}

