/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.internal.domain.AbstractFetchParent;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.EntityResultNode;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractEntityResultNode
extends AbstractFetchParent
implements EntityResultNode {
    private final EntityValuedModelPart referencedModelPart;
    private final DomainResult identifierResult;
    private final DomainResult discriminatorResult;
    private final DomainResult versionResult;
    private final LockMode lockMode;
    private final EntityMappingType targetType;

    public AbstractEntityResultNode(EntityValuedModelPart referencedModelPart, LockMode lockMode, NavigablePath navigablePath, DomainResultCreationState creationState) {
        this(referencedModelPart, lockMode, navigablePath, null, creationState);
    }

    public AbstractEntityResultNode(EntityValuedModelPart referencedModelPart, LockMode lockMode, NavigablePath navigablePath, EntityMappingType targetType, DomainResultCreationState creationState) {
        super(referencedModelPart.getEntityMappingType(), navigablePath);
        this.referencedModelPart = referencedModelPart;
        this.lockMode = lockMode;
        this.targetType = targetType;
        EntityMappingType entityDescriptor = referencedModelPart.getEntityMappingType();
        TableGroup entityTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(navigablePath);
        this.identifierResult = entityDescriptor.getIdentifierMapping().createDomainResult(navigablePath.append("{id}"), entityTableGroup, null, creationState);
        EntityDiscriminatorMapping discriminatorMapping = this.getDiscriminatorMapping(entityDescriptor, entityTableGroup);
        this.discriminatorResult = discriminatorMapping != null ? discriminatorMapping.createDomainResult(navigablePath.append("{discriminator}"), entityTableGroup, null, creationState) : null;
        EntityVersionMapping versionDescriptor = entityDescriptor.getVersionMapping();
        this.versionResult = versionDescriptor == null ? null : versionDescriptor.createDomainResult(navigablePath.append(versionDescriptor.getAttributeName()), entityTableGroup, null, creationState);
    }

    protected EntityDiscriminatorMapping getDiscriminatorMapping(EntityMappingType entityDescriptor, TableGroup entityTableGroup) {
        return entityDescriptor.getDiscriminatorMapping();
    }

    @Override
    public EntityValuedModelPart getReferencedMappingContainer() {
        return this.getEntityValuedModelPart();
    }

    @Override
    public EntityValuedModelPart getEntityValuedModelPart() {
        return this.referencedModelPart;
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.getEntityValuedModelPart().getEntityMappingType().getMappedJavaTypeDescriptor();
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    protected DomainResult getIdentifierResult() {
        return this.identifierResult;
    }

    protected DomainResult getDiscriminatorResult() {
        return this.discriminatorResult;
    }

    protected DomainResult getVersionResult() {
        return this.versionResult;
    }
}

