/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.AbstractFetchParentAccess;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.EntityInitializer;
import org.hibernate.sql.results.spi.RowProcessingState;

public class DelayedEntityFetchInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final NavigablePath navigablePath;
    private final EntityPersister concreteDescriptor;
    private final DomainResultAssembler identifierAssembler;
    private Object entityInstance;
    private Object identifier;

    protected DelayedEntityFetchInitializer(NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler identifierAssembler) {
        this.navigablePath = fetchedNavigable;
        this.concreteDescriptor = concreteDescriptor;
        this.identifierAssembler = identifierAssembler;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.entityInstance != null) {
            return;
        }
        this.identifier = this.identifierAssembler.assemble(rowProcessingState);
        if (this.identifier == null) {
            this.entityInstance = null;
        } else {
            if (this.concreteDescriptor.hasProxy()) {
                this.entityInstance = this.concreteDescriptor.createProxy(this.identifier, rowProcessingState.getSession());
            } else if (this.concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
                this.entityInstance = this.concreteDescriptor.instantiate(this.identifier, rowProcessingState.getSession());
            }
            this.notifyParentResolutionListeners(this.entityInstance);
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.entityInstance = null;
        this.identifier = null;
        this.clearParentResolutionListeners();
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public Object getParentKey() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstance != null) {
            listener.accept(this.entityInstance);
        } else {
            super.registerResolutionListener(listener);
        }
    }
}

