/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.entity.AbstractEntityResultNode;
import org.hibernate.sql.results.internal.domain.entity.EntityAssembler;
import org.hibernate.sql.results.internal.domain.entity.EntityRootInitializer;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.EntityResult;
import org.hibernate.sql.results.spi.EntityResultNode;
import org.hibernate.sql.results.spi.Initializer;

public class EntityResultImpl
extends AbstractEntityResultNode
implements EntityResult {
    private final String resultVariable;

    public EntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, String resultVariable, DomainResultCreationState creationState) {
        this(navigablePath, entityValuedModelPart, resultVariable, null, creationState);
    }

    public EntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, String resultVariable, EntityMappingType targetType, DomainResultCreationState creationState) {
        super(entityValuedModelPart, creationState.getSqlAstCreationState().determineLockMode(resultVariable), navigablePath, creationState);
        this.resultVariable = resultVariable;
        this.afterInitialize(creationState);
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    public DomainResultAssembler createResultAssembler(Consumer initializerCollector, AssemblerCreationState creationState) {
        EntityRootInitializer initializer = new EntityRootInitializer((EntityResultNode)this, this.getNavigablePath(), this.getLockMode(), this.getIdentifierResult(), this.getDiscriminatorResult(), this.getVersionResult(), (Consumer<Initializer>)initializerCollector, creationState);
        return new EntityAssembler(this.getResultJavaTypeDescriptor(), initializer);
    }
}

