/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.AbstractFetchParentAccess;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.EntityInitializer;
import org.hibernate.sql.results.spi.RowProcessingState;

public class SelectEntityInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final NavigablePath navigablePath;
    private final EntityPersister concreteDescriptor;
    private final DomainResultAssembler identifierAssembler;
    private final boolean unwrapProxy;
    private final boolean nullable;
    private Object entityInstance;

    protected SelectEntityInitializer(NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler identifierAssembler, boolean unwrapProxy, boolean nullable) {
        this.navigablePath = fetchedNavigable;
        this.concreteDescriptor = concreteDescriptor;
        this.identifierAssembler = identifierAssembler;
        this.unwrapProxy = unwrapProxy;
        this.nullable = nullable;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.entityInstance != null) {
            return;
        }
        Object id = this.identifierAssembler.assemble(rowProcessingState);
        if (id == null) {
            return;
        }
        String entityName = this.concreteDescriptor.getEntityName();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        this.entityInstance = session.internalLoad(entityName, id, false, this.nullable);
        if (this.entityInstance instanceof HibernateProxy) {
            boolean isProxyUnwrapEnabled = this.unwrapProxy && this.concreteDescriptor.isInstrumented();
            ((HibernateProxy)this.entityInstance).getHibernateLazyInitializer().setUnwrap(isProxyUnwrapEnabled);
        }
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.entityInstance = null;
        this.clearParentResolutionListeners();
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public Object getParentKey() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstance != null) {
            listener.accept(this.entityInstance);
        } else {
            super.registerResolutionListener(listener);
        }
    }
}

