/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.instantiation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.query.DynamicInstantiationNature;
import org.hibernate.query.sqm.sql.ConversionException;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.results.internal.domain.instantiation.DynamicInstantiationArgument;
import org.hibernate.sql.results.internal.domain.instantiation.DynamicInstantiationResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.jboss.logging.Logger;

public class DynamicInstantiation<T>
implements DomainResultProducer {
    private static final Logger log = Logger.getLogger(DynamicInstantiation.class);
    private final DynamicInstantiationNature nature;
    private final JavaTypeDescriptor<T> targetJavaTypeDescriptor;
    private List<DynamicInstantiationArgument> arguments;
    private boolean argumentAdditionsComplete = false;

    public DynamicInstantiation(DynamicInstantiationNature nature, JavaTypeDescriptor<T> targetJavaTypeDescriptor) {
        this.nature = nature;
        this.targetJavaTypeDescriptor = targetJavaTypeDescriptor;
    }

    public DynamicInstantiationNature getNature() {
        return this.nature;
    }

    public JavaTypeDescriptor<T> getTargetJavaTypeDescriptor() {
        return this.targetJavaTypeDescriptor;
    }

    public Class<T> getTargetJavaType() {
        return this.getTargetJavaTypeDescriptor().getJavaType();
    }

    public void addArgument(String alias, DomainResultProducer argumentResultProducer) {
        if (this.argumentAdditionsComplete) {
            throw new ConversionException("Unexpected call to DynamicInstantiation#addAgument after previously complete");
        }
        if (List.class.equals(this.getTargetJavaTypeDescriptor().getJavaType())) {
            if (alias != null) {
                log.debugf("Argument [%s] for dynamic List instantiation declared an 'injection alias' [%s] but such aliases are ignored for dynamic List instantiations", (Object)argumentResultProducer.toString(), (Object)alias);
            }
        } else if (Map.class.equals(this.getTargetJavaTypeDescriptor().getJavaType()) && alias == null) {
            log.warnf("Argument [%s] for dynamic Map instantiation did not declare an 'injection alias', but such aliases are needed for dynamic Map instantiations; will likely cause problems later processing query results", (Object)argumentResultProducer.toString());
        }
        if (this.arguments == null) {
            this.arguments = new ArrayList<DynamicInstantiationArgument>();
        }
        this.arguments.add(new DynamicInstantiationArgument(argumentResultProducer, alias));
    }

    public void complete() {
        this.argumentAdditionsComplete = true;
    }

    public List<DynamicInstantiationArgument> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return "DynamicInstantiation(" + this.getTargetJavaTypeDescriptor().getJavaType().getName() + ")";
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return new DynamicInstantiationResultImpl<T>(resultVariable, this.getNature(), this.getTargetJavaTypeDescriptor(), this.getArguments().stream().map(argument -> argument.buildArgumentDomainResult(creationState)).collect(Collectors.toList()));
    }
}

