/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.hibernate.query.sqm.sql.internal.InstantiationException;
import org.hibernate.sql.results.internal.domain.instantiation.ArgumentReader;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class DynamicInstantiationConstructorAssemblerImpl<R>
implements DomainResultAssembler<R> {
    private final Constructor<R> targetConstructor;
    private final JavaTypeDescriptor<R> resultType;
    private final List<ArgumentReader> argumentReaders;

    public DynamicInstantiationConstructorAssemblerImpl(Constructor<R> targetConstructor, JavaTypeDescriptor<R> resultType, List<ArgumentReader> argumentReaders) {
        this.targetConstructor = targetConstructor;
        this.resultType = resultType;
        this.argumentReaders = argumentReaders;
    }

    @Override
    public JavaTypeDescriptor<R> getAssembledJavaTypeDescriptor() {
        return this.resultType;
    }

    @Override
    public R assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        int numberOfArgs = this.argumentReaders.size();
        Object[] args = new Object[numberOfArgs];
        for (int i = 0; i < numberOfArgs; ++i) {
            args[i] = this.argumentReaders.get(i).assemble(rowProcessingState, options);
        }
        try {
            return this.targetConstructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException("Error performing dynamic instantiation : " + this.targetConstructor.getDeclaringClass().getName(), e.getCause());
        }
        catch (Exception e) {
            throw new InstantiationException("Error performing dynamic instantiation : " + this.targetConstructor.getDeclaringClass().getName(), e);
        }
    }
}

