/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.instantiation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.sql.results.internal.domain.instantiation.ArgumentReader;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class DynamicInstantiationMapAssemblerImpl
implements DomainResultAssembler<Map> {
    private final JavaTypeDescriptor<Map> mapJavaDescriptor;
    private final List<ArgumentReader<?>> argumentReaders;

    public DynamicInstantiationMapAssemblerImpl(JavaTypeDescriptor<Map> mapJavaDescriptor, List<ArgumentReader<?>> argumentReaders) {
        this.mapJavaDescriptor = mapJavaDescriptor;
        this.argumentReaders = argumentReaders;
        HashSet<String> aliases = new HashSet<String>();
        for (ArgumentReader<?> argumentReader : argumentReaders) {
            if (argumentReader.getAlias() == null) {
                throw new IllegalStateException("alias for Map dynamic instantiation argument cannot be null");
            }
            if (aliases.add(argumentReader.getAlias())) continue;
            throw new IllegalStateException("Encountered duplicate alias for Map dynamic instantiation argument [" + argumentReader.getAlias() + "]");
        }
    }

    @Override
    public JavaTypeDescriptor<Map> getAssembledJavaTypeDescriptor() {
        return this.mapJavaDescriptor;
    }

    @Override
    public Map assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        HashMap result = new HashMap();
        for (ArgumentReader<?> argumentReader : this.argumentReaders) {
            result.put(argumentReader.getAlias(), argumentReader.assemble(rowProcessingState, options));
        }
        return result;
    }
}

