/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.results.internal.domain.BiDirectionalFetchImpl;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.Fetchable;

public class CircularFetchDetector {
    public Fetch findBiDirectionalFetch(FetchParent fetchParent, Fetchable fetchable, SqlAstProcessingState creationState) {
        if (!fetchable.isCircular(fetchParent, creationState)) {
            return null;
        }
        NavigablePath navigablePath = fetchParent.getNavigablePath();
        if (navigablePath.getParent().getParent() == null) {
            return new BiDirectionalFetchImpl(navigablePath, fetchParent, fetchable, fetchParent.getNavigablePath().getParent());
        }
        return new BiDirectionalFetchImpl(navigablePath.append(fetchable.getFetchableName()), fetchParent, fetchable, navigablePath.getParent());
    }
}

