/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.spi.LoadingCollectionEntry;
import org.hibernate.sql.results.spi.LoadingEntityEntry;

public class LoadContexts {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(LoadContexts.class);
    private final PersistenceContext persistenceContext;
    private final StandardStack<JdbcValuesSourceProcessingState> jdbcValuesSourceProcessingStateStack = new StandardStack();

    public LoadContexts(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void register(JdbcValuesSourceProcessingState state) {
        this.jdbcValuesSourceProcessingStateStack.push(state);
    }

    public void deregister(JdbcValuesSourceProcessingState state) {
        JdbcValuesSourceProcessingState previous = this.jdbcValuesSourceProcessingStateStack.pop();
        if (previous != state) {
            throw new IllegalStateException("Illegal pop() with non-matching JdbcValuesSourceProcessingState");
        }
    }

    public LoadingEntityEntry findLoadingEntityEntry(EntityKey entityKey) {
        return this.jdbcValuesSourceProcessingStateStack.findCurrentFirst(state -> state.findLoadingEntityLocally(entityKey));
    }

    public LoadingCollectionEntry findLoadingCollectionEntry(CollectionKey collectionKey) {
        return this.jdbcValuesSourceProcessingStateStack.findCurrentFirst(state -> state.findLoadingCollectionLocally(collectionKey));
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    private SharedSessionContractImplementor getSession() {
        return this.getPersistenceContext().getSession();
    }

    public void cleanup() {
        if (!this.jdbcValuesSourceProcessingStateStack.isEmpty()) {
            log.debugf("LoadContexts still contained JdbcValuesSourceProcessingState registrations on cleanup", new Object[0]);
        }
        this.jdbcValuesSourceProcessingStateStack.clear();
    }
}

