/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.FetchingScrollableResultsImpl;
import org.hibernate.internal.ScrollableResultsImpl;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.sql.results.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.spi.JdbcValues;
import org.hibernate.sql.results.spi.JdbcValuesMapping;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;

public class ScrollableResultsConsumer<R>
implements ResultsConsumer<ScrollableResultsImplementor<R>, R> {
    public static final ScrollableResultsConsumer INSTANCE = new ScrollableResultsConsumer();

    public static <R> ScrollableResultsConsumer<R> instance() {
        return INSTANCE;
    }

    @Override
    public ScrollableResultsImplementor<R> consume(JdbcValues jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader) {
        if (this.containsCollectionFetches(jdbcValues.getValuesMapping())) {
            return new FetchingScrollableResultsImpl<R>(jdbcValues, processingOptions, jdbcValuesSourceProcessingState, rowProcessingState, rowReader, session);
        }
        return new ScrollableResultsImpl<R>(jdbcValues, processingOptions, jdbcValuesSourceProcessingState, rowProcessingState, rowReader, session);
    }

    private boolean containsCollectionFetches(JdbcValuesMapping valuesMapping) {
        return false;
    }
}

