/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.internal.StandardBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;

public class BasicTypeRegistry
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(BasicTypeRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final Map<SqlTypeDescriptor, Map<JavaTypeDescriptor<?>, BasicType<?>>> registryValues = new ConcurrentHashMap();
    private boolean primed;
    private Map<String, BasicType> typesByName = new ConcurrentHashMap<String, BasicType>(100, 0.75f, 1);

    public BasicTypeRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    public boolean isPrimed() {
        return this.primed;
    }

    public void primed() {
        this.primed = true;
    }

    public BasicType getRegisteredType(String key) {
        return this.typesByName.get(key);
    }

    public BasicType getRegisteredType(Class javaType) {
        return this.getRegisteredType(javaType.getName());
    }

    public BasicType<?> resolve(JavaTypeDescriptor<?> jtdToUse, SqlTypeDescriptor stdToUse) {
        return this.resolve(jtdToUse, stdToUse, () -> new StandardBasicTypeImpl(jtdToUse, stdToUse));
    }

    public BasicType<?> resolve(JavaTypeDescriptor<?> jtdToUse, SqlTypeDescriptor stdToUse, Supplier<BasicType<?>> creator) {
        Map typeByJtdForStd = this.registryValues.computeIfAbsent(stdToUse, sqlTypeDescriptor -> new ConcurrentHashMap());
        return typeByJtdForStd.computeIfAbsent(jtdToUse, javaDescriptor -> (BasicType)creator.get());
    }

    public void register(BasicType type) {
        this.register(type, type.getRegistrationKeys());
    }

    public void register(BasicType type, String key) {
        this.typesByName.put(key, type);
    }

    public void register(BasicType type, String ... keys) {
        if (type == null) {
            throw new HibernateException("Type to register cannot be null");
        }
        if (keys == null || keys.length == 0) {
            LOG.typeDefinedNoRegistrationKeys(type);
            return;
        }
        for (String key : keys) {
            if (key == null) continue;
            key = key.intern();
            LOG.debugf("Adding type registration %s -> %s", key, type);
            Type old = this.typesByName.put(key, type);
            if (old != null && old != type) {
                LOG.typeRegistrationOverridesPrevious(key, old);
            }
            Map mappingsForStdToUse = this.registryValues.computeIfAbsent(type.getSqlTypeDescriptor(), sqlTypeDescriptor -> new ConcurrentHashMap());
            mappingsForStdToUse.computeIfAbsent(type.getMappedJavaTypeDescriptor(), javaDescriptor -> new StandardBasicTypeImpl(javaDescriptor, type.getSqlTypeDescriptor()));
        }
    }

    public void register(UserType type, String ... keys) {
        this.register(new CustomType(type, keys, this.typeConfiguration));
    }

    public void unregister(String ... keys) {
        for (String key : keys) {
            BasicType basicType = this.typesByName.remove(key);
        }
    }
}

