/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Locale;
import javax.persistence.TemporalType;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.metamodel.model.domain.AllowableTemporalParameterType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.DateType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.TimeType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.InstantJavaDescriptor;
import org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class InstantType
extends AbstractSingleColumnStandardBasicType<Instant>
implements VersionType<Instant>,
LiteralType<Instant>,
AllowableTemporalParameterType<Instant> {
    public static final InstantType INSTANCE = new InstantType();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S 'Z'", Locale.ENGLISH);

    public InstantType() {
        super(TimestampTypeDescriptor.INSTANCE, InstantJavaDescriptor.INSTANCE);
    }

    @Override
    public String objectToSQLString(Instant value, Dialect dialect) throws Exception {
        return "{ts '" + FORMATTER.format(ZonedDateTime.ofInstant(value, ZoneId.of("UTC"))) + "'}";
    }

    @Override
    public Instant seed(SharedSessionContractImplementor session) {
        return Instant.now();
    }

    @Override
    public Instant next(Instant current, SharedSessionContractImplementor session) {
        return Instant.now();
    }

    @Override
    public Comparator<Instant> getComparator() {
        return ComparableComparator.INSTANCE;
    }

    @Override
    public String getName() {
        return Instant.class.getSimpleName();
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public AllowableTemporalParameterType resolveTemporalPrecision(TemporalType temporalPrecision, TypeConfiguration typeConfiguration) {
        switch (temporalPrecision) {
            case TIMESTAMP: {
                return this;
            }
            case TIME: {
                return TimeType.INSTANCE;
            }
            case DATE: {
                return DateType.INSTANCE;
            }
        }
        throw new QueryException("Instant type cannot be treated using `" + temporalPrecision.name() + "` precision");
    }
}

