/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.persistence.TemporalType;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.domain.AllowableTemporalParameterType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.LocalDateTimeType;
import org.hibernate.type.descriptor.java.LocalDateJavaDescriptor;
import org.hibernate.type.descriptor.sql.DateTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class LocalDateType
extends AbstractSingleColumnStandardBasicType<LocalDate>
implements LiteralType<LocalDate>,
AllowableTemporalParameterType<LocalDate> {
    public static final LocalDateType INSTANCE = new LocalDateType();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);

    public LocalDateType() {
        super(DateTypeDescriptor.INSTANCE, LocalDateJavaDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return LocalDate.class.getSimpleName();
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public String objectToSQLString(LocalDate value, Dialect dialect) throws Exception {
        return "{d '" + FORMATTER.format(value) + "'}";
    }

    @Override
    public AllowableTemporalParameterType resolveTemporalPrecision(TemporalType temporalPrecision, TypeConfiguration typeConfiguration) {
        switch (temporalPrecision) {
            case DATE: {
                return this;
            }
            case TIMESTAMP: {
                return LocalDateTimeType.INSTANCE;
            }
        }
        throw new QueryException("LocalDate type cannot be treated using `" + temporalPrecision.name() + "` precision");
    }
}

