/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.Time;
import java.util.Date;
import javax.persistence.TemporalType;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.domain.AllowableTemporalParameterType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.DateType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.descriptor.java.JdbcTimeTypeDescriptor;
import org.hibernate.type.descriptor.sql.TimeTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class TimeType
extends AbstractSingleColumnStandardBasicType<Date>
implements LiteralType<Date>,
AllowableTemporalParameterType<Date> {
    public static final TimeType INSTANCE = new TimeType();

    public TimeType() {
        super(TimeTypeDescriptor.INSTANCE, JdbcTimeTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "time";
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{this.getName(), Time.class.getName()};
    }

    @Override
    public String objectToSQLString(Date value, Dialect dialect) throws Exception {
        Time jdbcTime = Time.class.isInstance(value) ? (Time)value : new Time(value.getTime());
        return StringType.INSTANCE.objectToSQLString(jdbcTime.toString(), dialect);
    }

    @Override
    public AllowableTemporalParameterType resolveTemporalPrecision(TemporalType temporalPrecision, TypeConfiguration typeConfiguration) {
        switch (temporalPrecision) {
            case TIME: {
                return this;
            }
            case TIMESTAMP: {
                return TimestampType.INSTANCE;
            }
            case DATE: {
                return DateType.INSTANCE;
            }
        }
        throw new QueryException("Time type cannot be treated using `" + temporalPrecision.name() + "` precision");
    }
}

