/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.spi;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.sql.JdbcTypeFamilyInformation;
import org.hibernate.type.descriptor.sql.ObjectSqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.internal.SqlTypeDescriptorBaseline;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class SqlTypeDescriptorRegistry
implements SqlTypeDescriptorBaseline.BaselineTarget,
Serializable {
    private static final Logger log = Logger.getLogger(SqlTypeDescriptorRegistry.class);
    private ConcurrentHashMap<Integer, SqlTypeDescriptor> descriptorMap = new ConcurrentHashMap();

    public SqlTypeDescriptorRegistry(TypeConfiguration typeConfiguration) {
        SqlTypeDescriptorBaseline.prime(this);
    }

    @Override
    public void addDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        this.descriptorMap.put(sqlTypeDescriptor.getSqlType(), sqlTypeDescriptor);
    }

    public SqlTypeDescriptor getDescriptor(int jdbcTypeCode) {
        JdbcTypeFamilyInformation.Family family;
        SqlTypeDescriptor descriptor = this.descriptorMap.get(jdbcTypeCode);
        if (descriptor != null) {
            return descriptor;
        }
        if (JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode)) {
            log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", jdbcTypeCode);
        }
        if ((family = JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode)) != null) {
            for (int potentialAlternateTypeCode : family.getTypeCodes()) {
                if (potentialAlternateTypeCode == jdbcTypeCode) continue;
                SqlTypeDescriptor potentialAlternateDescriptor = this.descriptorMap.get(potentialAlternateTypeCode);
                if (potentialAlternateDescriptor != null) {
                    return potentialAlternateDescriptor;
                }
                if (!JdbcTypeNameMapper.isStandardTypeCode(potentialAlternateTypeCode)) continue;
                log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", potentialAlternateTypeCode);
            }
        }
        ObjectSqlTypeDescriptor fallBackDescriptor = new ObjectSqlTypeDescriptor(jdbcTypeCode);
        this.addDescriptor(fallBackDescriptor);
        return fallBackDescriptor;
    }

    public boolean hasRegisteredDescriptor(int jdbcTypeCode) {
        return this.descriptorMap.containsKey(jdbcTypeCode) || JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode) || JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode) != null;
    }
}

