/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.spi;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.spi.BasicTypeRegistration;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.uuid.LocalObjectUuidHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.metamodel.model.domain.internal.DomainMetamodelImpl;
import org.hibernate.metamodel.spi.DomainMetamodel;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptorRegistry;
import org.hibernate.type.internal.StandardBasicTypeImpl;
import org.hibernate.type.internal.TypeConfigurationRegistry;

@Incubating
public class TypeConfiguration
implements SessionFactoryObserver,
Serializable {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Scope.class);
    private final String uuid = LocalObjectUuidHelper.generateLocalObjectUuid();
    private final Scope scope;
    private final transient JavaTypeDescriptorRegistry javaTypeDescriptorRegistry;
    private final transient SqlTypeDescriptorRegistry sqlTypeDescriptorRegistry;
    private final transient BasicTypeRegistry basicTypeRegistry;
    private final transient Map<Integer, Set<String>> jdbcToHibernateTypeContributionMap = new HashMap<Integer, Set<String>>();
    private final ConcurrentHashMap<Class, BasicType> basicTypeByJavaType = new ConcurrentHashMap();

    public TypeConfiguration() {
        this.scope = new Scope(this);
        this.javaTypeDescriptorRegistry = new JavaTypeDescriptorRegistry(this);
        this.sqlTypeDescriptorRegistry = new SqlTypeDescriptorRegistry(this);
        this.basicTypeRegistry = new BasicTypeRegistry(this);
        StandardBasicTypes.prime(this);
        TypeConfigurationRegistry.INSTANCE.registerTypeConfiguration(this);
    }

    public String getUuid() {
        return this.uuid;
    }

    public BasicTypeRegistry getBasicTypeRegistry() {
        return this.basicTypeRegistry;
    }

    public JavaTypeDescriptorRegistry getJavaTypeDescriptorRegistry() {
        return this.javaTypeDescriptorRegistry;
    }

    public SqlTypeDescriptorRegistry getSqlTypeDescriptorRegistry() {
        return this.sqlTypeDescriptorRegistry;
    }

    public SqlTypeDescriptorIndicators getCurrentBaseSqlTypeIndicators() {
        return this.scope.getCurrentBaseSqlTypeIndicators();
    }

    public Map<Integer, Set<String>> getJdbcToHibernateTypeContributionMap() {
        return this.jdbcToHibernateTypeContributionMap;
    }

    public MetadataBuildingContext getMetadataBuildingContext() {
        return this.scope.getMetadataBuildingContext();
    }

    public void scope(MetadataBuildingContext metadataBuildingContext) {
        log.debugf("Scoping TypeConfiguration [%s] to MetadataBuildingContext [%s]", this, metadataBuildingContext);
        this.scope.setMetadataBuildingContext(metadataBuildingContext);
    }

    public DomainMetamodel scope(SessionFactoryImplementor sessionFactory) {
        log.debugf("Scoping TypeConfiguration [%s] to SessionFactoryImplementor [%s]", this, sessionFactory);
        if (this.scope.getMetadataBuildingContext() == null) {
            throw new IllegalStateException("MetadataBuildingContext not known");
        }
        this.scope.setSessionFactory(sessionFactory);
        sessionFactory.addObserver(this);
        return new DomainMetamodelImpl(sessionFactory, this);
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.scope.getSessionFactory();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.scope.getServiceRegistry();
    }

    @Override
    public void sessionFactoryCreated(SessionFactory factory) {
        log.tracef("Handling #sessionFactoryCreated from [%s] for TypeConfiguration", factory);
        this.scope.setMetadataBuildingContext(null);
    }

    @Override
    public void sessionFactoryClosed(SessionFactory factory) {
        log.tracef("Handling #sessionFactoryClosed from [%s] for TypeConfiguration", factory);
        TypeConfigurationRegistry.INSTANCE.deregisterTypeConfiguration(this);
        this.scope.unsetSessionFactory(factory);
    }

    public void addBasicTypeRegistrationContributions(List<BasicTypeRegistration> contributions) {
        for (BasicTypeRegistration basicTypeRegistration : contributions) {
            BasicType basicType = basicTypeRegistration.getBasicType();
            this.basicTypeRegistry.register(basicType, basicTypeRegistration.getRegistrationKeys());
            try {
                int[] jdbcTypes = basicType.sqlTypes(null);
                if (jdbcTypes.length != 1) continue;
                int jdbcType = jdbcTypes[0];
                Set hibernateTypes = this.jdbcToHibernateTypeContributionMap.computeIfAbsent(jdbcType, k -> new HashSet());
                hibernateTypes.add(basicType.getName());
            }
            catch (Exception e) {
                log.errorf(e, "Cannot register [%s] Hibernate Type contribution", basicType.getName());
            }
        }
    }

    private Object readResolve() throws InvalidObjectException {
        log.trace("Resolving serialized TypeConfiguration - readResolve");
        return TypeConfigurationRegistry.INSTANCE.findTypeConfiguration(this.getUuid());
    }

    public SqmExpressable<?> resolveArithmeticType(SqmExpressable<?> firstType, SqmExpressable<?> secondType, BinaryArithmeticOperator operator) {
        return this.resolveArithmeticType(firstType, secondType, operator == BinaryArithmeticOperator.DIVIDE);
    }

    public SqmExpressable<?> resolveArithmeticType(SqmExpressable<?> firstType, SqmExpressable<?> secondType, boolean isDivision) {
        if (isDivision) {
            return this.getBasicTypeRegistry().getRegisteredType(Number.class.getName());
        }
        if (TypeConfiguration.matchesJavaType(firstType, Double.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Double.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Float.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Float.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, BigDecimal.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, BigDecimal.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, BigInteger.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, BigInteger.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Long.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Long.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Integer.class)) {
            return firstType;
        }
        if (TypeConfiguration.matchesJavaType(secondType, Integer.class)) {
            return secondType;
        }
        if (TypeConfiguration.matchesJavaType(firstType, Short.class)) {
            return this.getBasicTypeRegistry().getRegisteredType(Integer.class.getName());
        }
        if (TypeConfiguration.matchesJavaType(secondType, Short.class)) {
            return this.getBasicTypeRegistry().getRegisteredType(Integer.class.getName());
        }
        return this.getBasicTypeRegistry().getRegisteredType(Number.class.getName());
    }

    private static boolean matchesJavaType(SqmExpressable type, Class javaType) {
        assert (javaType != null);
        return type != null && javaType.isAssignableFrom(type.getExpressableJavaTypeDescriptor().getJavaType());
    }

    public BasicType getBasicTypeForJavaType(Class<?> javaType) {
        BasicType existing = this.basicTypeByJavaType.get(javaType);
        if (existing != null) {
            return existing;
        }
        BasicType registeredType = this.getBasicTypeRegistry().getRegisteredType(javaType);
        if (registeredType != null) {
            this.basicTypeByJavaType.put(javaType, registeredType);
            return registeredType;
        }
        return null;
    }

    public BasicType standardBasicTypeForJavaType(Class<?> javaType) {
        if (javaType == null) {
            return null;
        }
        return this.standardBasicTypeForJavaType(javaType, javaTypeDescriptor -> new StandardBasicTypeImpl(javaTypeDescriptor, javaTypeDescriptor.getJdbcRecommendedSqlType(this.getCurrentBaseSqlTypeIndicators())));
    }

    public BasicType standardBasicTypeForJavaType(Class<?> javaType, Function<JavaTypeDescriptor<?>, BasicType> creator) {
        if (javaType == null) {
            return null;
        }
        return this.basicTypeByJavaType.computeIfAbsent(javaType, jt -> {
            BasicType registeredType = this.basicTypeRegistry.getRegisteredType(javaType);
            if (registeredType != null) {
                return registeredType;
            }
            JavaTypeDescriptor javaTypeDescriptor = this.javaTypeDescriptorRegistry.resolveDescriptor(javaType);
            return (BasicType)creator.apply(javaTypeDescriptor);
        });
    }

    private static class Scope
    implements Serializable {
        private final TypeConfiguration typeConfiguration;
        private transient MetadataBuildingContext metadataBuildingContext;
        private transient SessionFactoryImplementor sessionFactory;
        private String sessionFactoryName;
        private String sessionFactoryUuid;
        private transient SqlTypeDescriptorIndicators currentSqlTypeIndicators = new SqlTypeDescriptorIndicators(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }

            @Override
            public int getPreferredSqlTypeCodeForBoolean() {
                return 16;
            }
        };

        public Scope(TypeConfiguration typeConfiguration) {
            this.typeConfiguration = typeConfiguration;
        }

        public SqlTypeDescriptorIndicators getCurrentBaseSqlTypeIndicators() {
            return this.currentSqlTypeIndicators;
        }

        public MetadataBuildingContext getMetadataBuildingContext() {
            if (this.metadataBuildingContext == null) {
                throw new HibernateException("TypeConfiguration is not currently scoped to MetadataBuildingContext");
            }
            return this.metadataBuildingContext;
        }

        public ServiceRegistry getServiceRegistry() {
            if (this.metadataBuildingContext != null) {
                return this.metadataBuildingContext.getBootstrapContext().getServiceRegistry();
            }
            if (this.sessionFactory != null) {
                return this.sessionFactory.getServiceRegistry();
            }
            return null;
        }

        public void setMetadataBuildingContext(MetadataBuildingContext metadataBuildingContext) {
            this.metadataBuildingContext = metadataBuildingContext;
        }

        public SessionFactoryImplementor getSessionFactory() {
            if (this.sessionFactory == null) {
                if (this.sessionFactoryName == null && this.sessionFactoryUuid == null) {
                    throw new HibernateException("TypeConfiguration was not yet scoped to SessionFactory");
                }
                this.sessionFactory = SessionFactoryRegistry.INSTANCE.findSessionFactory(this.sessionFactoryUuid, this.sessionFactoryName);
                if (this.sessionFactory == null) {
                    throw new HibernateException("Could not find a SessionFactory [uuid=" + this.sessionFactoryUuid + ",name=" + this.sessionFactoryName + "]");
                }
            }
            return this.sessionFactory;
        }

        void setSessionFactory(SessionFactoryImplementor factory) {
            if (this.sessionFactory != null) {
                log.scopingTypesToSessionFactoryAfterAlreadyScoped(this.sessionFactory, factory);
            } else {
                CfgXmlAccessService cfgXmlAccessService;
                this.sessionFactoryUuid = factory.getUuid();
                String sfName = factory.getSessionFactoryOptions().getSessionFactoryName();
                if (sfName == null && (cfgXmlAccessService = factory.getServiceRegistry().getService(CfgXmlAccessService.class)).getAggregatedConfig() != null) {
                    sfName = cfgXmlAccessService.getAggregatedConfig().getSessionFactoryName();
                }
                this.sessionFactoryName = sfName;
            }
            this.sessionFactory = factory;
        }

        public void unsetSessionFactory(SessionFactory factory) {
            log.debugf("Un-scoping TypeConfiguration [%s] from SessionFactory [%s]", this, factory);
            this.sessionFactory = null;
        }

        private Object readResolve() throws InvalidObjectException {
            if (this.sessionFactory == null && (this.sessionFactoryName != null || this.sessionFactoryUuid != null)) {
                this.sessionFactory = SessionFactoryRegistry.INSTANCE.findSessionFactory(this.sessionFactoryUuid, this.sessionFactoryName);
                if (this.sessionFactory == null) {
                    throw new HibernateException("Could not find a SessionFactory [uuid=" + this.sessionFactoryUuid + ",name=" + this.sessionFactoryName + "]");
                }
            }
            return this;
        }
    }
}

