/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class TypeDefinitionRegistry {
    private static final Logger log = Logger.getLogger(TypeDefinitionRegistry.class);
    private final TypeDefinitionRegistry parent;
    private final Map<String, TypeDefinition> typeDefinitionMap = new HashMap<String, TypeDefinition>();

    public TypeDefinitionRegistry() {
        this(null);
    }

    public TypeDefinitionRegistry(TypeDefinitionRegistry parent) {
        this.parent = parent;
    }

    public TypeDefinition resolve(String typeName) {
        TypeDefinition localDefinition = this.typeDefinitionMap.get(typeName);
        if (localDefinition != null) {
            return localDefinition;
        }
        if (this.parent != null) {
            return this.parent.resolve(typeName);
        }
        return null;
    }

    public TypeDefinitionRegistry register(TypeDefinition typeDefinition) {
        return this.register(typeDefinition, DuplicationStrategy.OVERWRITE);
    }

    public TypeDefinitionRegistry register(TypeDefinition typeDefinition, DuplicationStrategy duplicationStrategy) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException("TypeDefinition to register cannot be null");
        }
        if (typeDefinition.getTypeImplementorClass() == null) {
            throw new IllegalArgumentException("TypeDefinition to register cannot define null #typeImplementorClass");
        }
        if (!StringHelper.isEmpty(typeDefinition.getName())) {
            this.register(typeDefinition.getName(), typeDefinition, duplicationStrategy);
        }
        if (typeDefinition.getRegistrationKeys() != null) {
            for (String registrationKey : typeDefinition.getRegistrationKeys()) {
                this.register(registrationKey, typeDefinition, duplicationStrategy);
            }
        }
        return this;
    }

    private void register(String name, TypeDefinition typeDefinition, DuplicationStrategy duplicationStrategy) {
        if (duplicationStrategy == DuplicationStrategy.KEEP) {
            if (!this.typeDefinitionMap.containsKey(name)) {
                this.typeDefinitionMap.put(name, typeDefinition);
            }
        } else {
            TypeDefinition existing = this.typeDefinitionMap.put(name, typeDefinition);
            if (existing != null && existing != typeDefinition) {
                if (duplicationStrategy == DuplicationStrategy.OVERWRITE) {
                    log.debugf("Overwrote existing registration [%s] for type definition.", (Object)name);
                } else {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Attempted to overwrite registration [%s] for type definition.", name));
                }
            }
        }
    }

    public static enum DuplicationStrategy {
        KEEP,
        OVERWRITE,
        DISALLOW;

    }
}

