/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.hibernate.MappingException;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolution;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.model.convert.internal.NamedEnumValueConverter;
import org.hibernate.metamodel.model.convert.internal.OrdinalEnumValueConverter;
import org.hibernate.metamodel.model.domain.AllowableTemporalParameterType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.SqlTypeDescriptorIndicatorCapable;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.TinyIntTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class InferredBasicValueResolver {
    public static BasicValue.Resolution from(Function<TypeConfiguration, BasicJavaDescriptor> explicitJavaTypeAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitSqlTypeAccess, Supplier<JavaTypeDescriptor> reflectedJtdResolver, SqlTypeDescriptorIndicators stdIndicators, Table table, Selectable selectable, String ownerName, String propertyName, TypeConfiguration typeConfiguration) {
        BasicType<?> legacyType;
        BasicType<?> jdbcMapping;
        BasicJavaDescriptor explicitJavaType = explicitJavaTypeAccess != null ? explicitJavaTypeAccess.apply(typeConfiguration) : null;
        SqlTypeDescriptor explicitSqlType = explicitSqlTypeAccess != null ? explicitSqlTypeAccess.apply(typeConfiguration) : null;
        BasicJavaDescriptor reflectedJtd = (BasicJavaDescriptor)reflectedJtdResolver.get();
        if (explicitJavaType != null) {
            if (explicitSqlType != null) {
                jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, explicitSqlType);
            } else {
                SqlTypeDescriptor inferredStd = explicitJavaType.getJdbcRecommendedSqlType(stdIndicators);
                jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, inferredStd);
            }
            legacyType = jdbcMapping;
        } else if (reflectedJtd != null) {
            if (explicitSqlType != null) {
                legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd, explicitSqlType);
            } else {
                BasicType registeredType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(reflectedJtd.getJavaType());
                jdbcMapping = legacyType = InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, registeredType);
            }
        } else if (explicitSqlType != null) {
            BasicJavaDescriptor recommendedJtd = explicitSqlType.getJdbcRecommendedJavaTypeMapping(typeConfiguration);
            BasicType<?> resolved = typeConfiguration.getBasicTypeRegistry().resolve(recommendedJtd, explicitSqlType);
            legacyType = jdbcMapping = InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, resolved);
        } else {
            throw new MappingException("Could not determine JavaTypeDescriptor nor SqlTypeDescriptor to use for BasicValue: owner = " + ownerName + "; property = " + propertyName + "; table = " + table.getName() + "; column = " + selectable.getText());
        }
        return new InferredBasicValueResolution(jdbcMapping, jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getSqlTypeDescriptor(), null, legacyType, null);
    }

    private static BasicType<?> resolveSqlTypeIndicators(SqlTypeDescriptorIndicators stdIndicators, BasicType<?> resolved) {
        if (resolved instanceof SqlTypeDescriptorIndicatorCapable) {
            SqlTypeDescriptorIndicatorCapable indicatorCapable = (SqlTypeDescriptorIndicatorCapable)resolved;
            BasicType indicatedType = indicatorCapable.resolveIndicatedType(stdIndicators);
            return indicatedType != null ? indicatedType : resolved;
        }
        return resolved;
    }

    public static InferredBasicValueResolution fromEnum(EnumJavaTypeDescriptor enumJavaDescriptor, BasicJavaDescriptor explicitJavaType, SqlTypeDescriptor explicitSqlType, SqlTypeDescriptorIndicators stdIndicators, TypeConfiguration typeConfiguration) {
        EnumType enumStyle = stdIndicators.getEnumeratedType() != null ? stdIndicators.getEnumeratedType() : EnumType.ORDINAL;
        switch (enumStyle) {
            case STRING: {
                BasicJavaDescriptor relationalJtd;
                if (explicitJavaType != null) {
                    if (!String.class.isAssignableFrom(explicitJavaType.getJavaType())) {
                        throw new MappingException("Explicit JavaTypeDescriptor [" + explicitJavaType + "] applied to enumerated value with EnumType#STRING should handle `java.lang.String` as its relational type descriptor");
                    }
                    relationalJtd = explicitJavaType;
                } else {
                    relationalJtd = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(String.class);
                }
                SqlTypeDescriptor std = explicitSqlType != null ? explicitSqlType : relationalJtd.getJdbcRecommendedSqlType(stdIndicators);
                NamedEnumValueConverter valueConverter = new NamedEnumValueConverter(enumJavaDescriptor, std, relationalJtd);
                org.hibernate.type.EnumType legacyEnumType = new org.hibernate.type.EnumType(enumJavaDescriptor.getJavaType(), valueConverter, typeConfiguration);
                CustomType legacyEnumTypeWrapper = new CustomType(legacyEnumType, typeConfiguration);
                BasicType<?> jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(relationalJtd, std);
                return new InferredBasicValueResolution(jdbcMapping, enumJavaDescriptor, relationalJtd, std, valueConverter, legacyEnumTypeWrapper, ImmutableMutabilityPlan.INSTANCE);
            }
            case ORDINAL: {
                BasicJavaDescriptor relationalJtd;
                if (explicitJavaType != null) {
                    if (!Integer.class.isAssignableFrom(explicitJavaType.getJavaType())) {
                        throw new MappingException("Explicit JavaTypeDescriptor [" + explicitJavaType + "] applied to enumerated value with EnumType#ORDINAL should handle `java.lang.Integer` as its relational type descriptor");
                    }
                    relationalJtd = explicitJavaType;
                } else {
                    relationalJtd = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(Integer.class);
                }
                SqlTypeDescriptor std = explicitSqlType != null ? explicitSqlType : TinyIntTypeDescriptor.INSTANCE;
                OrdinalEnumValueConverter valueConverter = new OrdinalEnumValueConverter(enumJavaDescriptor, std, relationalJtd);
                org.hibernate.type.EnumType legacyEnumType = new org.hibernate.type.EnumType(enumJavaDescriptor.getJavaType(), valueConverter, typeConfiguration);
                CustomType legacyEnumTypeWrapper = new CustomType(legacyEnumType, typeConfiguration);
                BasicType<?> jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(relationalJtd, std);
                return new InferredBasicValueResolution(jdbcMapping, enumJavaDescriptor, relationalJtd, std, valueConverter, legacyEnumTypeWrapper, ImmutableMutabilityPlan.INSTANCE);
            }
        }
        throw new MappingException("Unknown enumeration-style (JPA EnumType) : " + enumStyle);
    }

    public static InferredBasicValueResolution fromTemporal(TemporalJavaTypeDescriptor reflectedJtd, JavaTypeDescriptor explicitJavaType, SqlTypeDescriptor explicitSqlType, SqlTypeDescriptorIndicators stdIndicators, TypeConfiguration typeConfiguration) {
        TemporalType requestedTemporalPrecision = stdIndicators.getTemporalPrecision();
        if (explicitJavaType != null) {
            if (!TemporalJavaTypeDescriptor.class.isInstance(explicitJavaType)) {
                throw new MappingException("Explicit JavaTypeDescriptor [" + explicitJavaType + "] defined for temporal value must implement TemporalJavaTypeDescriptor");
            }
            TemporalJavaTypeDescriptor explicitTemporalJtd = (TemporalJavaTypeDescriptor)explicitJavaType;
            if (requestedTemporalPrecision != null && explicitTemporalJtd.getPrecision() != requestedTemporalPrecision) {
                throw new MappingException("Temporal precision (`javax.persistence.TemporalType`) mismatch... requested precision = " + requestedTemporalPrecision + "; explicit JavaTypeDescriptor (`" + explicitTemporalJtd + "`) precision = " + explicitTemporalJtd.getPrecision());
            }
            SqlTypeDescriptor std = explicitSqlType != null ? explicitSqlType : explicitTemporalJtd.getJdbcRecommendedSqlType(stdIndicators);
            BasicType<?> jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitTemporalJtd, std);
            return new InferredBasicValueResolution(jdbcMapping, explicitTemporalJtd, explicitTemporalJtd, std, null, jdbcMapping, explicitJavaType.getMutabilityPlan());
        }
        if (explicitSqlType != null) {
            TemporalJavaTypeDescriptor jtd = requestedTemporalPrecision != null ? reflectedJtd.resolveTypeForPrecision(requestedTemporalPrecision, typeConfiguration) : reflectedJtd;
            BasicType<?> jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(jtd, explicitSqlType);
            return new InferredBasicValueResolution(jdbcMapping, jtd, jtd, explicitSqlType, null, jdbcMapping, jtd.getMutabilityPlan());
        }
        BasicType registeredType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(reflectedJtd.getJavaType());
        AllowableTemporalParameterType legacyTemporalType = (AllowableTemporalParameterType)((Object)registeredType);
        BasicType basicType = requestedTemporalPrecision != null ? (BasicType)((Object)legacyTemporalType.resolveTemporalPrecision(requestedTemporalPrecision, typeConfiguration)) : registeredType;
        return new InferredBasicValueResolution(basicType, basicType.getJavaTypeDescriptor(), basicType.getJavaTypeDescriptor(), basicType.getSqlTypeDescriptor(), null, basicType, reflectedJtd.getMutabilityPlan());
    }
}

