/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.util.function.Function;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.converter.AttributeConverterTypeAdapter;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.internal.StandardBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class NamedConverterResolution<J>
implements BasicValue.Resolution<J> {
    private final JavaTypeDescriptor domainJtd;
    private final JavaTypeDescriptor relationalJtd;
    private final SqlTypeDescriptor relationalStd;
    private final JpaAttributeConverter valueConverter;
    private final MutabilityPlan mutabilityPlan;
    private final JdbcMapping jdbcMapping;
    private final BasicType legacyResolvedType;

    public static NamedConverterResolution from(ConverterDescriptor converterDescriptor, Function<TypeConfiguration, BasicJavaDescriptor> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, SqlTypeDescriptorIndicators sqlTypeIndicators, JpaAttributeConverterCreationContext converterCreationContext, MetadataBuildingContext context) {
        return NamedConverterResolution.fromInternal(explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, converterDescriptor.createJpaAttributeConverter(converterCreationContext), sqlTypeIndicators, context);
    }

    public static NamedConverterResolution from(String name, Function<TypeConfiguration, BasicJavaDescriptor> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, SqlTypeDescriptorIndicators sqlTypeIndicators, JpaAttributeConverterCreationContext converterCreationContext, MetadataBuildingContext context) {
        assert (name.startsWith("converted::"));
        String converterClassName = name.substring("converted::".length());
        StandardServiceRegistry serviceRegistry = context.getBootstrapContext().getServiceRegistry();
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        Class converterClass = classLoaderService.classForName(converterClassName);
        ClassBasedConverterDescriptor converterDescriptor = new ClassBasedConverterDescriptor(converterClass, context.getBootstrapContext().getClassmateContext());
        return NamedConverterResolution.fromInternal(explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, converterDescriptor.createJpaAttributeConverter(converterCreationContext), sqlTypeIndicators, context);
    }

    private static NamedConverterResolution fromInternal(Function<TypeConfiguration, BasicJavaDescriptor> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, JpaAttributeConverter converter, SqlTypeDescriptorIndicators sqlTypeIndicators, MetadataBuildingContext context) {
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaTypeDescriptor explicitJtd = explicitJtdAccess != null ? (JavaTypeDescriptor)explicitJtdAccess.apply(typeConfiguration) : null;
        JavaTypeDescriptor domainJtd = explicitJtd != null ? explicitJtd : converter.getDomainJavaDescriptor();
        SqlTypeDescriptor explicitStd = explicitStdAccess != null ? explicitStdAccess.apply(typeConfiguration) : null;
        JavaTypeDescriptor relationalJtd = converter.getRelationalJavaDescriptor();
        SqlTypeDescriptor relationalStd = explicitStd != null ? explicitStd : relationalJtd.getJdbcRecommendedSqlType(sqlTypeIndicators);
        MutabilityPlan explicitMutabilityPlan = explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null;
        return new NamedConverterResolution(domainJtd, relationalJtd, relationalStd, converter, explicitMutabilityPlan != null ? explicitMutabilityPlan : domainJtd.getMutabilityPlan());
    }

    public NamedConverterResolution(JavaTypeDescriptor domainJtd, JavaTypeDescriptor relationalJtd, SqlTypeDescriptor relationalStd, JpaAttributeConverter valueConverter, MutabilityPlan mutabilityPlan) {
        this.domainJtd = domainJtd;
        this.relationalJtd = relationalJtd;
        this.relationalStd = relationalStd;
        this.valueConverter = valueConverter;
        this.mutabilityPlan = mutabilityPlan;
        this.jdbcMapping = new StandardBasicTypeImpl(relationalJtd, relationalStd).getJdbcMapping();
        this.legacyResolvedType = new AttributeConverterTypeAdapter("converted::" + valueConverter.getConverterJavaTypeDescriptor().getJavaType().getName(), String.format("BasicType adapter for AttributeConverter<%s,%s>", domainJtd.getJavaType().getSimpleName(), relationalJtd.getJavaType().getSimpleName()), valueConverter, relationalStd, domainJtd.getJavaType(), relationalJtd.getJavaType(), domainJtd);
    }

    @Override
    public BasicType<J> getLegacyResolvedBasicType() {
        return this.legacyResolvedType;
    }

    @Override
    public JavaTypeDescriptor<J> getDomainJavaDescriptor() {
        return this.domainJtd;
    }

    @Override
    public JavaTypeDescriptor<?> getRelationalJavaDescriptor() {
        return this.relationalJtd;
    }

    @Override
    public SqlTypeDescriptor getRelationalSqlTypeDescriptor() {
        return this.relationalStd;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public JpaAttributeConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public String toString() {
        return "NamedConverterResolution(" + this.valueConverter.getConverterBean().getBeanClass().getName() + ')';
    }
}

