/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.util.function.Function;
import javax.persistence.TemporalType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.RowVersionType;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class VersionResolution<E>
implements BasicValue.Resolution<E> {
    private final JavaTypeDescriptor jtd;
    private final SqlTypeDescriptor std;
    private final JdbcMapping jdbcMapping;
    private final BasicType legacyType;

    public static <E> VersionResolution<E> from(Function<TypeConfiguration, Class> implicitJavaTypeAccess, Function<TypeConfiguration, BasicJavaDescriptor> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, final TypeConfiguration typeConfiguration, MetadataBuildingContext context) {
        Class implicitJavaType = implicitJavaTypeAccess.apply(typeConfiguration);
        JavaTypeDescriptor registered = typeConfiguration.getJavaTypeDescriptorRegistry().resolveDescriptor(implicitJavaType);
        if (registered instanceof PrimitiveByteArrayTypeDescriptor) {
            return new VersionResolution<E>(RowVersionType.INSTANCE.getJavaTypeDescriptor(), RowVersionType.INSTANCE.getSqlTypeDescriptor(), RowVersionType.INSTANCE, RowVersionType.INSTANCE);
        }
        BasicJavaDescriptor jtd = (BasicJavaDescriptor)registered;
        SqlTypeDescriptor std = jtd.getJdbcRecommendedSqlType(new SqlTypeDescriptorIndicators(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }

            @Override
            public TemporalType getTemporalPrecision() {
                return TemporalType.TIMESTAMP;
            }
        });
        BasicType<?> basicType = typeConfiguration.getBasicTypeRegistry().resolve(jtd, std);
        BasicType legacyType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(jtd.getJavaType());
        assert (legacyType.getSqlTypeDescriptor().equals(std));
        return new VersionResolution<E>(jtd, std, basicType, legacyType);
    }

    public VersionResolution(JavaTypeDescriptor javaTypeDescriptor, SqlTypeDescriptor sqlTypeDescriptor, JdbcMapping jdbcMapping, BasicType legacyType) {
        this.jtd = javaTypeDescriptor;
        this.std = sqlTypeDescriptor;
        this.jdbcMapping = jdbcMapping;
        this.legacyType = legacyType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public BasicType getLegacyResolvedBasicType() {
        return this.legacyType;
    }

    @Override
    public JavaTypeDescriptor<E> getDomainJavaDescriptor() {
        return this.jtd;
    }

    @Override
    public JavaTypeDescriptor<?> getRelationalJavaDescriptor() {
        return this.jtd;
    }

    @Override
    public SqlTypeDescriptor getRelationalSqlTypeDescriptor() {
        return this.std;
    }

    @Override
    public BasicValueConverter<E, E> getValueConverter() {
        return null;
    }

    @Override
    public MutabilityPlan<E> getMutabilityPlan() {
        return ImmutableMutabilityPlan.instance();
    }
}

