/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.spi;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.spi.NamedQueryDefinition;

public abstract class AbstractNamedQueryDefinition
implements NamedQueryDefinition {
    private final String name;
    private final Boolean cacheable;
    private final String cacheRegion;
    private final CacheMode cacheMode;
    private final FlushMode flushMode;
    private final Boolean readOnly;
    private final LockOptions lockOptions;
    private final Integer timeout;
    private final Integer fetchSize;
    private final String comment;
    private final Map<String, Object> hints;

    public AbstractNamedQueryDefinition(String name, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, LockOptions lockOptions, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints) {
        this.name = name;
        this.cacheable = cacheable;
        this.cacheRegion = cacheRegion;
        this.cacheMode = cacheMode;
        this.flushMode = flushMode;
        this.readOnly = readOnly;
        this.lockOptions = lockOptions;
        this.timeout = timeout;
        this.fetchSize = fetchSize;
        this.comment = comment;
        this.hints = hints == null ? new HashMap<String, Object>() : new HashMap<String, Object>(hints);
    }

    @Override
    public String getRegistrationName() {
        return this.name;
    }

    public Boolean getCacheable() {
        return this.cacheable;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public String getComment() {
        return this.comment;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    protected static abstract class AbstractBuilder<T extends AbstractBuilder> {
        private final String name;
        private Boolean cacheable;
        private String cacheRegion;
        private CacheMode cacheMode;
        private FlushMode flushMode;
        private Boolean readOnly;
        private LockOptions lockOptions;
        private Integer timeout;
        private Integer fetchSize;
        private String comment;
        private Map<String, Object> hints;

        public AbstractBuilder(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        protected abstract T getThis();

        public T setCacheable(Boolean cacheable) {
            this.cacheable = cacheable;
            return this.getThis();
        }

        public T setCacheRegion(String cacheRegion) {
            this.cacheRegion = cacheRegion;
            return this.getThis();
        }

        public T setCacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            return this.getThis();
        }

        public T setLockOptions(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this.getThis();
        }

        public T setTimeout(Integer timeout) {
            this.timeout = timeout;
            return this.getThis();
        }

        public T setFlushMode(FlushMode flushMode) {
            this.flushMode = flushMode;
            return this.getThis();
        }

        public T setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this.getThis();
        }

        public T setFetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            return this.getThis();
        }

        public T setComment(String comment) {
            this.comment = comment;
            return this.getThis();
        }

        public Boolean getCacheable() {
            return this.cacheable;
        }

        public String getCacheRegion() {
            return this.cacheRegion;
        }

        public CacheMode getCacheMode() {
            return this.cacheMode;
        }

        public FlushMode getFlushMode() {
            return this.flushMode;
        }

        public Boolean getReadOnly() {
            return this.readOnly;
        }

        public LockOptions getLockOptions() {
            return this.lockOptions;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public Integer getFetchSize() {
            return this.fetchSize;
        }

        public String getComment() {
            return this.comment;
        }

        public void addHint(String name, Object value) {
            if (this.hints == null) {
                this.hints = new HashMap<String, Object>();
            }
            this.hints.put(name, value);
        }

        public T addHints(Map<String, Object> hintsMap) {
            if (this.hints == null) {
                this.hints = new HashMap<String, Object>();
            }
            this.hints.putAll(hintsMap);
            return this.getThis();
        }

        public Map<String, Object> getHints() {
            return this.hints;
        }
    }
}

