/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.collection.internal.AbstractSetSemantics;
import org.hibernate.collection.internal.PersistentSortedSet;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.persister.collection.CollectionPersister;

public class StandardSortedSetSemantics
extends AbstractSetSemantics<SortedSet<?>> {
    public static final StandardSortedSetSemantics INSTANCE = new StandardSortedSetSemantics();

    private StandardSortedSetSemantics() {
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return CollectionClassification.SORTED_SET;
    }

    @Override
    public Class<SortedSet<?>> getCollectionJavaType() {
        return SortedSet.class;
    }

    @Override
    public SortedSet instantiateRaw(int anticipatedSize, CollectionPersister collectionDescriptor) {
        return new TreeSet(collectionDescriptor.getSortingComparator());
    }

    @Override
    public PersistentCollection instantiateWrapper(Object key, CollectionPersister collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentSortedSet(session);
    }

    @Override
    public PersistentCollection wrap(Object rawCollection, CollectionPersister collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentSortedSet(session, (SortedSet)rawCollection);
    }

    @Override
    public Iterator getElementIterator(SortedSet<?> rawCollection) {
        return rawCollection.iterator();
    }
}

