/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.CacheIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadUpdateLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteUpdateLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.lock.UpdateLockingStrategy;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.dialect.sequence.CacheSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.sql.CacheJoinFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.StandardBasicTypes;

public class CacheDialect
extends Dialect {
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("constraint (", ") violated", sqle.getMessage()));

    public CacheDialect() {
        this.registerColumnType(16, "bit");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(2014, "timestamp");
        this.registerColumnType(2004, "image");
        this.registerColumnType(2005, "text");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.use_sql_comments", "false");
    }

    private static void useJdbcEscape(QueryEngine queryEngine, String name) {
        queryEngine.getSqmFunctionRegistry().wrapInJdbcEscape(name, queryEngine.getSqmFunctionRegistry().findFunctionDescriptor(name));
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 19;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.space(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.weekQuarter(queryEngine);
        CommonFunctionFactory.daynameMonthname(queryEngine);
        CommonFunctionFactory.toCharNumberDateTimestamp(queryEngine);
        CommonFunctionFactory.truncate(queryEngine);
        CommonFunctionFactory.dayofweekmonthyear(queryEngine);
        CommonFunctionFactory.repeat_replicate(queryEngine);
        CommonFunctionFactory.datepartDatename(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.chr_char(queryEngine);
        CommonFunctionFactory.nowCurdateCurtime(queryEngine);
        CommonFunctionFactory.sysdate(queryEngine);
        CommonFunctionFactory.stddev(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.variance(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        CommonFunctionFactory.lastDay(queryEngine);
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("locate", StandardBasicTypes.INTEGER, "$find(?2, ?1)", "$find(?2, ?1, ?3)").setArgumentListSignature("(pattern, string[, start])");
        CacheDialect.useJdbcEscape(queryEngine, "sin");
        CacheDialect.useJdbcEscape(queryEngine, "cos");
        CacheDialect.useJdbcEscape(queryEngine, "tan");
        CacheDialect.useJdbcEscape(queryEngine, "asin");
        CacheDialect.useJdbcEscape(queryEngine, "acos");
        CacheDialect.useJdbcEscape(queryEngine, "atan");
        CacheDialect.useJdbcEscape(queryEngine, "atan2");
        CacheDialect.useJdbcEscape(queryEngine, "exp");
        CacheDialect.useJdbcEscape(queryEngine, "log");
        CacheDialect.useJdbcEscape(queryEngine, "log10");
        CacheDialect.useJdbcEscape(queryEngine, "pi");
        CacheDialect.useJdbcEscape(queryEngine, "truncate");
        CacheDialect.useJdbcEscape(queryEngine, "left");
        CacheDialect.useJdbcEscape(queryEngine, "right");
        CacheDialect.useJdbcEscape(queryEngine, "hour");
        CacheDialect.useJdbcEscape(queryEngine, "minute");
        CacheDialect.useJdbcEscape(queryEngine, "second");
        CacheDialect.useJdbcEscape(queryEngine, "week");
        CacheDialect.useJdbcEscape(queryEngine, "quarter");
        CacheDialect.useJdbcEscape(queryEngine, "dayname");
        CacheDialect.useJdbcEscape(queryEngine, "monthname");
        CacheDialect.useJdbcEscape(queryEngine, "dayofweek");
        CacheDialect.useJdbcEscape(queryEngine, "dayofmonth");
        CacheDialect.useJdbcEscape(queryEngine, "dayofyear");
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return "datepart(?1, ?2)";
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "dateadd(millisecond, (?2)/1e6, ?3)";
            }
        }
        return "dateadd(?1, ?2, ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "datediff(millisecond, ?2, ?3)*1e6";
            }
        }
        return "datediff(?1, ?2, ?3)";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        return new StringBuilder(300).append(" ADD CONSTRAINT ").append(constraintName).append(" FOREIGN KEY ").append(constraintName).append(" (").append(String.join((CharSequence)", ", foreignKey)).append(") REFERENCES ").append(referencedTable).append(" (").append(String.join((CharSequence)", ", primaryKey)).append(") ").toString();
    }

    @Override
    public boolean hasSelfReferentialForeignKeyBug() {
        return true;
    }

    @Override
    public String getNativeIdentifierGeneratorStrategy() {
        return "identity";
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new CacheIdentityColumnSupport();
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return CacheSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select name from InterSystems.Sequences";
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: {
                return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_WRITE: {
                return new PessimisticWriteUpdateLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_READ: {
                return new PessimisticReadUpdateLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC: {
                return new OptimisticLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
        }
        if (lockMode.greaterThan(LockMode.READ)) {
            return new UpdateLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    @Override
    public LimitHandler getLimitHandler() {
        return TopLimitHandler.INSTANCE;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public String getLowercaseFunction() {
        return "lower";
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public JoinFragment createOuterJoinFragment() {
        return new CacheJoinFragment();
    }

    @Override
    public String getNoColumnsInsertString() {
        return " default values";
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlStateClassCode = JdbcExceptionHelper.extractSqlStateClassCode(sqlException);
            if (sqlStateClassCode != null) {
                int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
                if (errorCode >= 119 && errorCode <= 127 && errorCode != 126) {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                if (sqlStateClassCode.equals("22") || sqlStateClassCode.equals("21") || sqlStateClassCode.equals("02")) {
                    return new DataException(message, sqlException, sql);
                }
            }
            return null;
        };
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return OracleDialect.datetimeFormat(format, false).result();
    }
}

