/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SpannerDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.PostgreSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;

public class CockroachDialect
extends Dialect {
    public CockroachDialect() {
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(-3, "bytes");
        this.registerColumnType(-2, "bytes");
        this.registerColumnType(-1, "string");
        this.registerColumnType(2005, "string");
        this.registerColumnType(-15, "string($l)");
        this.registerColumnType(-9, "string($l)");
        this.registerColumnType(-16, "string");
        this.registerColumnType(2011, "string");
        this.registerColumnType(2000, "json");
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.char_chr(queryEngine);
        CommonFunctionFactory.overlay(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        CommonFunctionFactory.substringFromFor(queryEngine);
        CommonFunctionFactory.locate_positionSubstring(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.reverse(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.md5(queryEngine);
        CommonFunctionFactory.sha1(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.bitLength(queryEngine);
        CommonFunctionFactory.cbrt(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("format", "experimental_strftime").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(2).setArgumentListSignature("(datetime as pattern)").register();
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return String.valueOf(bool);
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return true;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    @Override
    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return PostgreSQLSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select sequence_name, sequence_schema, sequence_catalog, start_value, minimum_value, maximum_value, increment from information_schema.sequences";
    }

    @Override
    public boolean supportsNationalizedTypes() {
        return false;
    }

    @Override
    protected String wrapDateLiteral(String date) {
        return DateTimeUtils.wrapAsAnsiDateLiteral(date);
    }

    @Override
    protected String wrapTimeLiteral(String time) {
        return DateTimeUtils.wrapAsAnsiTimeLiteral(time);
    }

    @Override
    protected String wrapTimestampLiteral(String timestamp) {
        return "timestamp with time zone '" + timestamp + "'";
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "(" + super.extractPattern(unit) + "+1)";
            }
            case SECOND: {
                return "(extract(second from ?2)+extract(microsecond from ?2)/1e6)";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "dayofyear";
            }
            case DAY_OF_WEEK: {
                return "dayofweek";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        switch (unit) {
            case NANOSECOND: {
                return "(?3 + (?2)/1e3 * interval '1 microsecond')";
            }
            case NATIVE: {
                return "(?3 + (?2) * interval '1 microsecond')";
            }
            case QUARTER: {
                return "(?3 + (?2) * interval '3 month')";
            }
            case WEEK: {
                return "(?3 + (?2) * interval '7 day')";
            }
        }
        return "(?3 + (?2) * interval '1 ?1')";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        switch (unit) {
            case YEAR: {
                return "(extract(year from ?3)-extract(year from ?2))";
            }
            case QUARTER: {
                return "(extract(year from ?3)*4-extract(year from ?2)*4+extract(month from ?3)//3-extract(month from ?2)//3)";
            }
            case MONTH: {
                return "(extract(year from ?3)*12-extract(year from ?2)*12+extract(month from ?3)-extract(month from ?2))";
            }
        }
        if (!toTimestamp && !fromTimestamp) {
            return "(?3-?2)" + TemporalUnit.DAY.conversionFactor(unit, this);
        }
        switch (unit) {
            case WEEK: {
                return "extract_duration(hour from ?3-?2)/168";
            }
            case DAY: {
                return "extract_duration(hour from ?3-?2)/24";
            }
            case NANOSECOND: {
                return "extract_duration(microsecond from ?3-?2)*1e3";
            }
        }
        return "extract_duration(?1 from ?3-?2)";
    }

    @Override
    public String translateDurationField(TemporalUnit unit) {
        return unit == TemporalUnit.NATIVE ? "microsecond" : super.translateDurationField(unit);
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return SpannerDialect.datetimeFormat(format).result();
    }

    @Override
    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }
}

