/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.DerbyConcatEmulation;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.DerbyLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DB2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.CastType;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.TempIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DerbyCaseFragment;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorDerbyDatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.sql.DecimalTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class DerbyDialect
extends Dialect {
    private final int version;
    private final LimitHandler limitHandler;

    int getVersion() {
        return this.version;
    }

    public DerbyDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    public DerbyDialect() {
        this(1000);
    }

    public DerbyDialect(int version) {
        this.version = version;
        this.registerColumnType(-7, 1L, "boolean");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(2, "decimal($p,$s)");
        this.registerColumnType(-2, "varchar($l) for bit data");
        this.registerColumnType(-2, 254L, "char($l) for bit data");
        this.registerColumnType(-3, "varchar($l) for bit data");
        this.registerColumnType(2004, "blob($l)");
        this.registerColumnType(2005, "clob($l)");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(2014, "timestamp");
        this.registerDerbyKeywords();
        this.limitHandler = this.getVersion() < 1050 ? AbstractLimitHandler.NO_LIMIT : new DerbyLimitHandler(this.getVersion() >= 1060);
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 31;
    }

    @Override
    public int getFloatPrecision() {
        return 23;
    }

    @Override
    public int getDoublePrecision() {
        return 52;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.chr_char(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.sinh(queryEngine);
        CommonFunctionFactory.cosh(queryEngine);
        CommonFunctionFactory.tanh(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.rand(queryEngine);
        CommonFunctionFactory.trim1(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.substring_substr(queryEngine);
        CommonFunctionFactory.leftRight_substrLength(queryEngine);
        CommonFunctionFactory.characterLength_length(queryEngine);
        CommonFunctionFactory.power_expLn(queryEngine);
        queryEngine.getSqmFunctionRegistry().patternDescriptorBuilder("round", "floor(?1*1e?2+0.5)/1e?2").setExactArgumentCount(2).setInvariantType(StandardBasicTypes.DOUBLE).register();
        queryEngine.getSqmFunctionRegistry().register("concat", new DerbyConcatEmulation());
        queryEngine.getSqmFunctionRegistry().patternDescriptorBuilder("lpad", "case when length(?1)<?2 then substr(char('',?2)||?1,length(?1)) else ?1 end").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(2).setArgumentListSignature("(string, length)").register();
        queryEngine.getSqmFunctionRegistry().patternDescriptorBuilder("rpad", "case when length(?1)<?2 then substr(?1||char('',?2),1,?2) else ?1 end").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(2).setArgumentListSignature("(string, length)").register();
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day(?2)";
            }
            case DAY_OF_YEAR: {
                return "({fn timestampdiff(sql_tsi_day, date(char(year(?2),4)||'-01-01'),?2)}+1)";
            }
            case DAY_OF_WEEK: {
                return "(mod({fn timestampdiff(sql_tsi_day, {d '2000-01-01'}, ?2)},7)+1)";
            }
        }
        return "?1(?2)";
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_YEAR: 
            case DAY_OF_WEEK: 
            case WEEK: {
                throw new NotYetImplementedFor6Exception("field type not supported on Derby: " + (Object)((Object)unit));
            }
            case DAY_OF_MONTH: {
                return "day";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case FLOAT: {
                return "cast(double(?1) as real)";
            }
            case DOUBLE: {
                return "double(?1)";
            }
            case BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return "case when ?1 in('t','true','T','TRUE') then true when ?1 in('f','false','F','FALSE') then false end";
                    }
                    case LONG: 
                    case INTEGER: {
                        return "(?1<>0)";
                    }
                }
                break;
            }
            case LONG: 
            case INTEGER: {
                if (from != CastType.BOOLEAN || this.getVersion() < 1070) break;
                return "case ?1 when false then 0 when true then 1 end";
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "{fn timestampadd(sql_tsi_frac_second, mod(bigint(?2),1000000000), {fn timestampadd(sql_tsi_second, bigint((?2)/1000000000), ?3)})}";
            }
        }
        return "{fn timestampadd(sql_tsi_?1, bigint(?2), ?3)}";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "{fn timestampdiff(sql_tsi_frac_second, ?2, ?3)}";
            }
        }
        return "{fn timestampdiff(sql_tsi_?1, ?2, ?3)}";
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return this.getVersion() < 1070 ? super.toBooleanValueString(bool) : String.valueOf(bool);
    }

    @Override
    public String getCrossJoinSeparator() {
        return this.getVersion() < 1060 ? ", " : super.getCrossJoinSeparator();
    }

    @Override
    public CaseFragment createCaseFragment() {
        return new DerbyCaseFragment();
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion() < 1060 ? super.getSequenceSupport() : DB2SequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getVersion() < 1060 ? "select sys.sysschemas.schemaname as sequence_schema, sys.syssequences.* from sys.syssequences left join sys.sysschemas on sys.syssequences.schemaid = sys.sysschemas.schemaid" : null;
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getVersion() < 1060 ? SequenceInformationExtractorNoOpImpl.INSTANCE : SequenceInformationExtractorDerbyDatabaseImpl.INSTANCE;
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        return DB2Dialect.selectNullString(sqlType);
    }

    @Override
    public String getFromDual() {
        return "from (values 0) as dual";
    }

    @Override
    public boolean supportsCommentOn() {
        return false;
    }

    @Override
    public String getForUpdateString() {
        return " for update with rs";
    }

    @Override
    public String getWriteLockString(int timeout) {
        return " for update with rs";
    }

    @Override
    public String getReadLockString(int timeout) {
        return " for read only with rs";
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return " for update of " + aliases + " with rs";
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "values current timestamp";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new DB2IdentityColumnSupport();
    }

    @Override
    public boolean supportsTuplesInSubqueries() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean supportsParametersInInsertSelect() {
        return true;
    }

    @Override
    public boolean requiresCastingOfParametersInSelectClause() {
        return true;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        return sqlCode == 2 ? DecimalTypeDescriptor.INSTANCE : super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public String getNotExpression(String expression) {
        return "not (" + expression + ")";
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.applyIdentifierCasing(dbMetaData);
        builder.applyReservedWords(dbMetaData);
        builder.applyReservedWords(this.getKeywords());
        builder.setNameQualifierSupport(this.getNameQualifierSupport());
        return builder.build();
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if ("40XL1".equals(sqlState) || "40XL2".equals(sqlState)) {
                throw new LockTimeoutException(message, sqlException, sql);
            }
            return null;
        };
    }

    @Override
    public String translateDatetimeFormat(String format) {
        throw new NotYetImplementedFor6Exception("format() function not supported on Derby");
    }

    private void registerDerbyKeywords() {
        this.registerKeyword("ADD");
        this.registerKeyword("ALL");
        this.registerKeyword("ALLOCATE");
        this.registerKeyword("ALTER");
        this.registerKeyword("AND");
        this.registerKeyword("ANY");
        this.registerKeyword("ARE");
        this.registerKeyword("AS");
        this.registerKeyword("ASC");
        this.registerKeyword("ASSERTION");
        this.registerKeyword("AT");
        this.registerKeyword("AUTHORIZATION");
        this.registerKeyword("AVG");
        this.registerKeyword("BEGIN");
        this.registerKeyword("BETWEEN");
        this.registerKeyword("BIT");
        this.registerKeyword("BOOLEAN");
        this.registerKeyword("BOTH");
        this.registerKeyword("BY");
        this.registerKeyword("CALL");
        this.registerKeyword("CASCADE");
        this.registerKeyword("CASCADED");
        this.registerKeyword("CASE");
        this.registerKeyword("CAST");
        this.registerKeyword("CHAR");
        this.registerKeyword("CHARACTER");
        this.registerKeyword("CHECK");
        this.registerKeyword("CLOSE");
        this.registerKeyword("COLLATE");
        this.registerKeyword("COLLATION");
        this.registerKeyword("COLUMN");
        this.registerKeyword("COMMIT");
        this.registerKeyword("CONNECT");
        this.registerKeyword("CONNECTION");
        this.registerKeyword("CONSTRAINT");
        this.registerKeyword("CONSTRAINTS");
        this.registerKeyword("CONTINUE");
        this.registerKeyword("CONVERT");
        this.registerKeyword("CORRESPONDING");
        this.registerKeyword("COUNT");
        this.registerKeyword("CREATE");
        this.registerKeyword("CURRENT");
        this.registerKeyword("CURRENT_DATE");
        this.registerKeyword("CURRENT_TIME");
        this.registerKeyword("CURRENT_TIMESTAMP");
        this.registerKeyword("CURRENT_USER");
        this.registerKeyword("CURSOR");
        this.registerKeyword("DEALLOCATE");
        this.registerKeyword("DEC");
        this.registerKeyword("DECIMAL");
        this.registerKeyword("DECLARE");
        this.registerKeyword("DEFERRABLE");
        this.registerKeyword("DEFERRED");
        this.registerKeyword("DELETE");
        this.registerKeyword("DESC");
        this.registerKeyword("DESCRIBE");
        this.registerKeyword("DIAGNOSTICS");
        this.registerKeyword("DISCONNECT");
        this.registerKeyword("DISTINCT");
        this.registerKeyword("DOUBLE");
        this.registerKeyword("DROP");
        this.registerKeyword("ELSE");
        this.registerKeyword("END");
        this.registerKeyword("ENDEXEC");
        this.registerKeyword("ESCAPE");
        this.registerKeyword("EXCEPT");
        this.registerKeyword("EXCEPTION");
        this.registerKeyword("EXEC");
        this.registerKeyword("EXECUTE");
        this.registerKeyword("EXISTS");
        this.registerKeyword("EXPLAIN");
        this.registerKeyword("EXTERNAL");
        this.registerKeyword("FALSE");
        this.registerKeyword("FETCH");
        this.registerKeyword("FIRST");
        this.registerKeyword("FLOAT");
        this.registerKeyword("FOR");
        this.registerKeyword("FOREIGN");
        this.registerKeyword("FOUND");
        this.registerKeyword("FROM");
        this.registerKeyword("FULL");
        this.registerKeyword("FUNCTION");
        this.registerKeyword("GET");
        this.registerKeyword("GET_CURRENT_CONNECTION");
        this.registerKeyword("GLOBAL");
        this.registerKeyword("GO");
        this.registerKeyword("GOTO");
        this.registerKeyword("GRANT");
        this.registerKeyword("GROUP");
        this.registerKeyword("HAVING");
        this.registerKeyword("HOUR");
        this.registerKeyword("IDENTITY");
        this.registerKeyword("IMMEDIATE");
        this.registerKeyword("IN");
        this.registerKeyword("INDICATOR");
        this.registerKeyword("INITIALLY");
        this.registerKeyword("INNER");
        this.registerKeyword("INOUT");
        this.registerKeyword("INPUT");
        this.registerKeyword("INSENSITIVE");
        this.registerKeyword("INSERT");
        this.registerKeyword("INT");
        this.registerKeyword("INTEGER");
        this.registerKeyword("INTERSECT");
        this.registerKeyword("INTO");
        this.registerKeyword("IS");
        this.registerKeyword("ISOLATION");
        this.registerKeyword("JOIN");
        this.registerKeyword("KEY");
        this.registerKeyword("LAST");
        this.registerKeyword("LEFT");
        this.registerKeyword("LIKE");
        this.registerKeyword("LONGINT");
        this.registerKeyword("LOWER");
        this.registerKeyword("LTRIM");
        this.registerKeyword("MATCH");
        this.registerKeyword("MAX");
        this.registerKeyword("MIN");
        this.registerKeyword("MINUTE");
        this.registerKeyword("NATIONAL");
        this.registerKeyword("NATURAL");
        this.registerKeyword("NCHAR");
        this.registerKeyword("NVARCHAR");
        this.registerKeyword("NEXT");
        this.registerKeyword("NO");
        this.registerKeyword("NOT");
        this.registerKeyword("NULL");
        this.registerKeyword("NULLIF");
        this.registerKeyword("NUMERIC");
        this.registerKeyword("OF");
        this.registerKeyword("ON");
        this.registerKeyword("ONLY");
        this.registerKeyword("OPEN");
        this.registerKeyword("OPTION");
        this.registerKeyword("OR");
        this.registerKeyword("ORDER");
        this.registerKeyword("OUT");
        this.registerKeyword("OUTER");
        this.registerKeyword("OUTPUT");
        this.registerKeyword("OVERLAPS");
        this.registerKeyword("PAD");
        this.registerKeyword("PARTIAL");
        this.registerKeyword("PREPARE");
        this.registerKeyword("PRESERVE");
        this.registerKeyword("PRIMARY");
        this.registerKeyword("PRIOR");
        this.registerKeyword("PRIVILEGES");
        this.registerKeyword("PROCEDURE");
        this.registerKeyword("PUBLIC");
        this.registerKeyword("READ");
        this.registerKeyword("REAL");
        this.registerKeyword("REFERENCES");
        this.registerKeyword("RELATIVE");
        this.registerKeyword("RESTRICT");
        this.registerKeyword("REVOKE");
        this.registerKeyword("RIGHT");
        this.registerKeyword("ROLLBACK");
        this.registerKeyword("ROWS");
        this.registerKeyword("RTRIM");
        this.registerKeyword("SCHEMA");
        this.registerKeyword("SCROLL");
        this.registerKeyword("SECOND");
        this.registerKeyword("SELECT");
        this.registerKeyword("SESSION_USER");
        this.registerKeyword("SET");
        this.registerKeyword("SMALLINT");
        this.registerKeyword("SOME");
        this.registerKeyword("SPACE");
        this.registerKeyword("SQL");
        this.registerKeyword("SQLCODE");
        this.registerKeyword("SQLERROR");
        this.registerKeyword("SQLSTATE");
        this.registerKeyword("SUBSTR");
        this.registerKeyword("SUBSTRING");
        this.registerKeyword("SUM");
        this.registerKeyword("SYSTEM_USER");
        this.registerKeyword("TABLE");
        this.registerKeyword("TEMPORARY");
        this.registerKeyword("TIMEZONE_HOUR");
        this.registerKeyword("TIMEZONE_MINUTE");
        this.registerKeyword("TO");
        this.registerKeyword("TRAILING");
        this.registerKeyword("TRANSACTION");
        this.registerKeyword("TRANSLATE");
        this.registerKeyword("TRANSLATION");
        this.registerKeyword("TRUE");
        this.registerKeyword("UNION");
        this.registerKeyword("UNIQUE");
        this.registerKeyword("UNKNOWN");
        this.registerKeyword("UPDATE");
        this.registerKeyword("UPPER");
        this.registerKeyword("USER");
        this.registerKeyword("USING");
        this.registerKeyword("VALUES");
        this.registerKeyword("VARCHAR");
        this.registerKeyword("VARYING");
        this.registerKeyword("VIEW");
        this.registerKeyword("WHENEVER");
        this.registerKeyword("WHERE");
        this.registerKeyword("WITH");
        this.registerKeyword("WORK");
        this.registerKeyword("WRITE");
        this.registerKeyword("XML");
        this.registerKeyword("XMLEXISTS");
        this.registerKeyword("XMLPARSE");
        this.registerKeyword("XMLSERIALIZE");
        this.registerKeyword("YEAR");
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableStrategy(new IdTable(rootEntityDescriptor, basename -> "HT_" + basename), () -> new TempIdTableExporter(true, this::getTypeName){

            @Override
            protected String getCreateCommand() {
                return "declare global temporary table";
            }

            @Override
            protected String getCreateOptions() {
                return "not logged";
            }
        }, AfterUseAction.CLEAN, TempTableDdlTransactionHandling.NONE, runtimeModelCreationContext.getSessionFactory());
    }
}

