/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.NullPrecedence;
import org.hibernate.ScrollMode;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.ColumnAliasExtractor;
import org.hibernate.dialect.LegacySequenceSupport;
import org.hibernate.dialect.LobMergeStrategy;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.TypeNames;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.CastStrEmulation;
import org.hibernate.dialect.function.CoalesceIfnullEmulation;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CurrentFunction;
import org.hibernate.dialect.function.ExtractFunction;
import org.hibernate.dialect.function.InsertSubstringOverlayEmulation;
import org.hibernate.dialect.function.LocatePositionEmulation;
import org.hibernate.dialect.function.LpadRpadPadEmulation;
import org.hibernate.dialect.function.TimestampaddFunction;
import org.hibernate.dialect.function.TimestampdiffFunction;
import org.hibernate.dialect.function.TrimFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupportImpl;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadSelectLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteSelectLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.pagination.LegacyLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.DefaultUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.env.internal.DefaultSchemaNameResolver;
import org.hibernate.engine.jdbc.env.spi.AnsiSqlKeywords;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.spi.ConversionContext;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.io.StreamCopier;
import org.hibernate.loader.BatchLoadSizingStrategy;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.CastType;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.PersistentTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.PhysicalIdTableExporter;
import org.hibernate.query.sqm.mutation.internal.inline.InlineStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ANSICaseFragment;
import org.hibernate.sql.ANSIJoinFragment;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.ANSICaseExpressionWalker;
import org.hibernate.sql.ast.spi.CaseExpressionWalker;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardAuxiliaryDatabaseObjectExporter;
import org.hibernate.tool.schema.internal.StandardForeignKeyExporter;
import org.hibernate.tool.schema.internal.StandardIndexExporter;
import org.hibernate.tool.schema.internal.StandardSequenceExporter;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.internal.StandardUniqueKeyExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public abstract class Dialect
implements ConversionContext {
    public static final String DEFAULT_BATCH_SIZE = "15";
    protected static final String NO_BATCH = "0";
    public static final String QUOTE = "`\"[";
    public static final String CLOSED_QUOTE = "`\"]";
    private final TypeNames typeNames = new TypeNames();
    private final TypeNames hibernateTypeNames = new TypeNames();
    private final Properties properties = new Properties();
    private final Set<String> sqlKeywords = new HashSet<String>();
    private final UniqueDelegate uniqueDelegate;
    private DefaultSizeStrategy defaultSizeStrategy;
    protected static final LobMergeStrategy LEGACY_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            return target;
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            return target;
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            return target;
        }
    };
    protected static final LobMergeStrategy STREAM_XFER_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setBinaryStream(1L);
                    InputStream detachedStream = original.getBinaryStream();
                    StreamCopier.copy(detachedStream, connectedStream);
                    return target;
                }
                catch (SQLException e) {
                    throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge BLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeBlob(original, target, session);
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setAsciiStream(1L);
                    InputStream detachedStream = original.getAsciiStream();
                    StreamCopier.copy(detachedStream, connectedStream);
                    return target;
                }
                catch (SQLException e) {
                    throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge CLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeClob(original, target, session);
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setAsciiStream(1L);
                    InputStream detachedStream = original.getAsciiStream();
                    StreamCopier.copy(detachedStream, connectedStream);
                    return target;
                }
                catch (SQLException e) {
                    throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge NCLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeNClob(original, target, session);
        }
    };
    protected static final LobMergeStrategy NEW_LOCATOR_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            try {
                LobCreator lobCreator = session.getFactory().getServiceRegistry().getService(JdbcServices.class).getLobCreator(session);
                return original == null ? lobCreator.createBlob(ArrayHelper.EMPTY_BYTE_ARRAY) : lobCreator.createBlob(original.getBinaryStream(), original.length());
            }
            catch (SQLException e) {
                throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge BLOB data");
            }
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            try {
                LobCreator lobCreator = session.getFactory().getServiceRegistry().getService(JdbcServices.class).getLobCreator(session);
                return original == null ? lobCreator.createClob("") : lobCreator.createClob(original.getCharacterStream(), original.length());
            }
            catch (SQLException e) {
                throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge CLOB data");
            }
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            try {
                LobCreator lobCreator = session.getFactory().getServiceRegistry().getService(JdbcServices.class).getLobCreator(session);
                return original == null ? lobCreator.createNClob("") : lobCreator.createNClob(original.getCharacterStream(), original.length());
            }
            catch (SQLException e) {
                throw session.getFactory().getSQLExceptionHelper().convert(e, "unable to merge NCLOB data");
            }
        }
    };
    private static final ViolatedConstraintNameExtractor EXTRACTOR = sqle -> null;
    private StandardTableExporter tableExporter = new StandardTableExporter(this);
    private StandardSequenceExporter sequenceExporter = new StandardSequenceExporter(this);
    private StandardIndexExporter indexExporter = new StandardIndexExporter(this);
    private StandardForeignKeyExporter foreignKeyExporter = new StandardForeignKeyExporter(this);
    private StandardUniqueKeyExporter uniqueKeyExporter = new StandardUniqueKeyExporter(this);
    private StandardAuxiliaryDatabaseObjectExporter auxiliaryObjectExporter = new StandardAuxiliaryDatabaseObjectExporter(this);
    protected final BatchLoadSizingStrategy STANDARD_DEFAULT_BATCH_LOAD_SIZING_STRATEGY = new BatchLoadSizingStrategy(){

        @Override
        public int determineOptimalBatchLoadSize(int numberOfKeyColumns, int numberOfKeys) {
            return 50;
        }
    };

    protected Dialect() {
        this.registerColumnType(-7, 1L, "bit");
        this.registerColumnType(-7, "bit($l)");
        this.registerColumnType(16, "boolean");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(7, "real");
        this.registerColumnType(6, "float($p)");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp($p)");
        this.registerColumnType(2014, "timestamp($p) with time zone");
        this.registerColumnType(2013, "time with time zone");
        this.registerColumnType(-2, "binary($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(-15, "nchar($l)");
        this.registerColumnType(-9, "nvarchar($l)");
        this.registerColumnType(2011, "nclob");
        this.registerHibernateType(16, StandardBasicTypes.BOOLEAN.getTypeName());
        this.registerHibernateType(-7, 64L, StandardBasicTypes.LONG.getTypeName());
        this.registerHibernateType(-7, 32L, StandardBasicTypes.INTEGER.getTypeName());
        this.registerHibernateType(-7, 16L, StandardBasicTypes.SHORT.getTypeName());
        this.registerHibernateType(-7, 8L, StandardBasicTypes.BYTE.getTypeName());
        this.registerHibernateType(-7, 1L, StandardBasicTypes.BOOLEAN.getTypeName());
        this.registerHibernateType(7, StandardBasicTypes.FLOAT.getTypeName());
        this.registerHibernateType(8, StandardBasicTypes.DOUBLE.getTypeName());
        this.registerHibernateType(6, StandardBasicTypes.DOUBLE.getTypeName());
        this.registerHibernateType(2, StandardBasicTypes.BIG_DECIMAL.getTypeName());
        this.registerHibernateType(3, StandardBasicTypes.BIG_DECIMAL.getTypeName());
        this.registerHibernateType(-5, StandardBasicTypes.LONG.getTypeName());
        this.registerHibernateType(4, StandardBasicTypes.INTEGER.getTypeName());
        this.registerHibernateType(5, StandardBasicTypes.SHORT.getTypeName());
        this.registerHibernateType(-6, StandardBasicTypes.BYTE.getTypeName());
        this.registerHibernateType(1, 1L, StandardBasicTypes.CHARACTER.getTypeName());
        this.registerHibernateType(1, StandardBasicTypes.STRING.getTypeName());
        this.registerHibernateType(12, 1L, StandardBasicTypes.CHARACTER.getTypeName());
        this.registerHibernateType(12, StandardBasicTypes.STRING.getTypeName());
        this.registerHibernateType(-9, StandardBasicTypes.NSTRING.getTypeName());
        this.registerHibernateType(-1, StandardBasicTypes.TEXT.getTypeName());
        this.registerHibernateType(-16, StandardBasicTypes.NTEXT.getTypeName());
        this.registerHibernateType(-2, StandardBasicTypes.BINARY.getTypeName());
        this.registerHibernateType(-3, StandardBasicTypes.BINARY.getTypeName());
        this.registerHibernateType(-4, StandardBasicTypes.IMAGE.getTypeName());
        this.registerHibernateType(2004, StandardBasicTypes.BLOB.getTypeName());
        this.registerHibernateType(2005, StandardBasicTypes.CLOB.getTypeName());
        this.registerHibernateType(91, StandardBasicTypes.DATE.getTypeName());
        this.registerHibernateType(92, StandardBasicTypes.TIME.getTypeName());
        this.registerHibernateType(93, StandardBasicTypes.TIMESTAMP.getTypeName());
        if (this.supportsPartitionBy()) {
            this.registerKeyword("PARTITION");
        }
        this.uniqueDelegate = new DefaultUniqueDelegate(this);
        this.defaultSizeStrategy = new DefaultSizeStrategyImpl();
    }

    static Size binaryToDecimalPrecision(int code, Size size) {
        return code == 6 && size != null && size.getPrecision() != null ? Size.precision((int)Math.ceil((double)size.getPrecision().intValue() / 53.0 * 17.0)) : size;
    }

    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        CommonFunctionFactory.aggregates(queryEngine);
        CommonFunctionFactory.groupings(queryEngine);
        CommonFunctionFactory.everyAny_sumCase(queryEngine);
        CommonFunctionFactory.math(queryEngine);
        CommonFunctionFactory.trigonometry(queryEngine);
        CommonFunctionFactory.coalesce(queryEngine);
        CommonFunctionFactory.nullif(queryEngine);
        CommonFunctionFactory.leftRight(queryEngine);
        CommonFunctionFactory.replace(queryEngine);
        CommonFunctionFactory.concat(queryEngine);
        CommonFunctionFactory.lowerUpper(queryEngine);
        CommonFunctionFactory.substring(queryEngine);
        CommonFunctionFactory.locate(queryEngine);
        CommonFunctionFactory.length_characterLength(queryEngine);
        queryEngine.getSqmFunctionRegistry().register("position", new LocatePositionEmulation());
        queryEngine.getSqmFunctionRegistry().register("overlay", new InsertSubstringOverlayEmulation());
        queryEngine.getSqmFunctionRegistry().register("trim", new TrimFunction(this));
        queryEngine.getSqmFunctionRegistry().register("cast", new CastFunction(this));
        queryEngine.getSqmFunctionRegistry().register("extract", new ExtractFunction(this));
        CommonFunctionFactory.leastGreatest(queryEngine);
        queryEngine.getSqmFunctionRegistry().register("ifnull", new CoalesceIfnullEmulation());
        CommonFunctionFactory.pad(queryEngine);
        queryEngine.getSqmFunctionRegistry().register("pad", new LpadRpadPadEmulation());
        queryEngine.getSqmFunctionRegistry().register("str", new CastStrEmulation());
        CommonFunctionFactory.format_toChar(queryEngine);
        queryEngine.getSqmFunctionRegistry().register("timestampadd", new TimestampaddFunction(this));
        queryEngine.getSqmFunctionRegistry().register("timestampdiff", new TimestampdiffFunction(this));
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("dateadd", "timestampadd");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("datediff", "timestampdiff");
        queryEngine.getSqmFunctionRegistry().register("current_date", new CurrentFunction("current_date", this.currentDate(), StandardBasicTypes.DATE));
        queryEngine.getSqmFunctionRegistry().register("current_time", new CurrentFunction("current_time", this.currentTime(), StandardBasicTypes.TIME));
        queryEngine.getSqmFunctionRegistry().register("current_timestamp", new CurrentFunction("current_timestamp", this.currentTimestamp(), StandardBasicTypes.TIMESTAMP));
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("current date", "current_date");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("current time", "current_time");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("current timestamp", "current_timestamp");
        queryEngine.getSqmFunctionRegistry().register("local_date", new CurrentFunction("local_date", this.currentDate(), StandardBasicTypes.LOCAL_DATE));
        queryEngine.getSqmFunctionRegistry().register("local_time", new CurrentFunction("local_time", this.currentLocalTime(), StandardBasicTypes.LOCAL_TIME));
        queryEngine.getSqmFunctionRegistry().register("local_datetime", new CurrentFunction("local_datetime", this.currentLocalTimestamp(), StandardBasicTypes.LOCAL_DATE_TIME));
        queryEngine.getSqmFunctionRegistry().register("offset_datetime", new CurrentFunction("offset_datetime", this.currentTimestampWithTimeZone(), StandardBasicTypes.OFFSET_DATE_TIME));
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("local date", "local_date");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("local time", "local_time");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("local datetime", "local_datetime");
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("offset datetime", "offset_datetime");
        queryEngine.getSqmFunctionRegistry().register("instant", new CurrentFunction("instant", this.currentTimestamp(), StandardBasicTypes.INSTANT));
        queryEngine.getSqmFunctionRegistry().registerAlternateKey("current_instant", "instant");
    }

    public String currentDate() {
        return "current_date";
    }

    public String currentTime() {
        return "current_time";
    }

    public String currentTimestamp() {
        return "current_timestamp";
    }

    public String currentLocalTime() {
        return this.currentTime();
    }

    public String currentLocalTimestamp() {
        return this.currentTimestamp();
    }

    public String currentTimestampWithTimeZone() {
        return this.currentTimestamp();
    }

    public String extractPattern(TemporalUnit unit) {
        return "extract(?1 from ?2)";
    }

    public String castPattern(CastType from, CastType to) {
        return "cast(?1 as ?2)";
    }

    public String trimPattern(TrimSpec specification, char character) {
        return character == ' ' ? "trim(" + (Object)((Object)specification) + " from ?1)" : "trim(" + (Object)((Object)specification) + " '" + character + "' from ?1)";
    }

    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        throw new NotYetImplementedFor6Exception();
    }

    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        throw new NotYetImplementedFor6Exception();
    }

    @Deprecated
    public static Dialect getDialect() throws HibernateException {
        return Dialect.instantiateDialect(Environment.getProperties().getProperty("hibernate.dialect"));
    }

    @Deprecated
    public static Dialect getDialect(Properties props) throws HibernateException {
        String dialectName = props.getProperty("hibernate.dialect");
        if (dialectName == null) {
            return Dialect.getDialect();
        }
        return Dialect.instantiateDialect(dialectName);
    }

    @Deprecated
    private static Dialect instantiateDialect(String dialectName) throws HibernateException {
        if (dialectName == null) {
            throw new HibernateException("The dialect was not set. Set the property hibernate.dialect.");
        }
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate given dialect class: " + dialectName, e);
        }
    }

    public final Properties getDefaultProperties() {
        return this.properties;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
    }

    public String getRawTypeName(int code) throws HibernateException {
        String result = this.typeNames.get(code);
        if (result == null) {
            throw new HibernateException("No default type mapping for (java.sql.Types) " + code);
        }
        int paren = result.indexOf(40);
        return paren > 0 ? result.substring(0, paren) : result;
    }

    public String getRawTypeName(SqlTypeDescriptor sqlTypeDescriptor) throws HibernateException {
        return this.getRawTypeName(sqlTypeDescriptor.getJdbcTypeCode());
    }

    public String getTypeName(SqlTypeDescriptor sqlTypeDescriptor) throws HibernateException {
        return this.getTypeName(sqlTypeDescriptor.getJdbcTypeCode());
    }

    public String getTypeName(int code) throws HibernateException {
        return this.getTypeName(code, Size.nil());
    }

    public String getTypeName(int code, Size size) throws HibernateException {
        String result = this.typeNames.get(code, size.getLength(), size.getPrecision(), size.getScale());
        if (result == null) {
            switch (code) {
                case -1: {
                    return this.getTypeName(12, size);
                }
                case -16: {
                    return this.getTypeName(-9, size);
                }
                case -4: {
                    return this.getTypeName(-3, size);
                }
            }
            throw new HibernateException(String.format("No type mapping for java.sql.Types code: %s, length: %s", code, size.getLength()));
        }
        return result;
    }

    public String getTypeName(SqlTypeDescriptor sqlTypeDescriptor, Size size) {
        return this.getTypeName(sqlTypeDescriptor.getJdbcTypeCode(), size);
    }

    public String getCastTypeName(SqlExpressable type, Long length, Integer precision, Integer scale) {
        Size size;
        if (length == null && precision == null) {
            size = this.getDefaultSizeStrategy().resolveDefaultSize(type.getJdbcMapping().getSqlTypeDescriptor(), type.getJdbcMapping().getJavaTypeDescriptor());
        } else {
            if (precision != null && scale == null) {
                scale = type.getJdbcMapping().getJavaTypeDescriptor().getDefaultSqlScale();
            }
            size = new Size().setLength(length).setPrecision(precision).setScale(scale);
        }
        return this.getTypeName(type.getJdbcMapping().getSqlTypeDescriptor(), size);
    }

    protected void registerColumnType(int code, long capacity, String name) {
        this.typeNames.put(code, capacity, name);
    }

    protected void registerColumnType(int code, String name) {
        this.typeNames.put(code, name);
    }

    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        if (sqlTypeDescriptor == null) {
            throw new IllegalArgumentException("sqlTypeDescriptor is null");
        }
        if (!sqlTypeDescriptor.canBeRemapped()) {
            return sqlTypeDescriptor;
        }
        SqlTypeDescriptor overridden = this.getSqlTypeDescriptorOverride(sqlTypeDescriptor.getJdbcTypeCode());
        return overridden == null ? sqlTypeDescriptor : overridden;
    }

    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        ClobTypeDescriptor descriptor;
        switch (sqlCode) {
            case 2005: {
                descriptor = this.useInputStreamToInsertBlob() ? ClobTypeDescriptor.STREAM_BINDING : null;
                break;
            }
            default: {
                descriptor = null;
            }
        }
        return descriptor;
    }

    public LobMergeStrategy getLobMergeStrategy() {
        return NEW_LOCATOR_LOB_MERGE_STRATEGY;
    }

    public String getHibernateTypeName(int code) throws HibernateException {
        String result = this.hibernateTypeNames.get(code);
        if (result == null) {
            throw new HibernateException("No Hibernate type mapping for java.sql.Types code: " + code);
        }
        return result;
    }

    public boolean isTypeNameRegistered(String typeName) {
        return this.typeNames.containsTypeName(typeName);
    }

    public String getHibernateTypeName(int code, Integer length, Integer precision, Integer scale) throws HibernateException {
        String result = this.hibernateTypeNames.get(code, length.longValue(), precision, scale);
        if (result == null) {
            throw new HibernateException(String.format("No Hibernate type mapping for type [code=%s, length=%s]", code, length));
        }
        return result;
    }

    protected void registerHibernateType(int code, long capacity, String name) {
        this.hibernateTypeNames.put(code, capacity, name);
    }

    protected void registerHibernateType(int code, String name) {
        this.hibernateTypeNames.put(code, name);
    }

    @Deprecated
    public Class getNativeIdentifierGeneratorClass() {
        return this.getIdentityColumnSupport().supportsIdentityColumns() ? IdentityGenerator.class : SequenceStyleGenerator.class;
    }

    public String getNativeIdentifierGeneratorStrategy() {
        return this.getIdentityColumnSupport().supportsIdentityColumns() ? "identity" : "sequence";
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return new IdentityColumnSupportImpl();
    }

    public SequenceSupport getSequenceSupport() {
        return new LegacySequenceSupport(this);
    }

    public String getQuerySequencesString() {
        return null;
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getQuerySequencesString() == null ? SequenceInformationExtractorNoOpImpl.INSTANCE : SequenceInformationExtractorLegacyImpl.INSTANCE;
    }

    public String getSelectGUIDString() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support GUIDs");
    }

    public String getFromDual() {
        return "";
    }

    public LimitHandler getLimitHandler() {
        if (this.supportsLimit()) {
            return new LegacyLimitHandler(this);
        }
        throw new UnsupportedOperationException("this dialect does not support query pagination");
    }

    public boolean supportsLockTimeouts() {
        return true;
    }

    public boolean isLockTimeoutParameterized() {
        return false;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: {
                return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_WRITE: {
                return new PessimisticWriteSelectLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_READ: {
                return new PessimisticReadSelectLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC: {
                return new OptimisticLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    public String getForUpdateString(LockOptions lockOptions) {
        return this.getForUpdateString(lockOptions.getLockMode(), lockOptions.getTimeOut());
    }

    private String getForUpdateString(LockMode lockMode, int timeout) {
        switch (lockMode) {
            case UPGRADE: {
                return this.getForUpdateString();
            }
            case PESSIMISTIC_READ: {
                return this.getReadLockString(timeout);
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(timeout);
            }
            case PESSIMISTIC_FORCE_INCREMENT: 
            case UPGRADE_NOWAIT: 
            case FORCE: {
                return this.getForUpdateNowaitString();
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString();
            }
        }
        return "";
    }

    public String getForUpdateString(LockMode lockMode) {
        return this.getForUpdateString(lockMode, -1);
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getWriteLockString(int timeout) {
        return this.getForUpdateString();
    }

    public String getWriteLockString(String aliases, int timeout) {
        return this.getWriteLockString(timeout);
    }

    public String getReadLockString(int timeout) {
        return this.getForUpdateString();
    }

    public String getReadLockString(String aliases, int timeout) {
        return this.getReadLockString(timeout);
    }

    public boolean forUpdateOfColumns() {
        return false;
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString();
    }

    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode = lockOptions.getLockMode();
        Iterator<Map.Entry<String, LockMode>> itr = lockOptions.getAliasLockIterator();
        while (itr.hasNext()) {
            Map.Entry<String, LockMode> entry = itr.next();
            LockMode lm = entry.getValue();
            if (!lm.greaterThan(lockMode)) continue;
            lockMode = lm;
        }
        lockOptions.setLockMode(lockMode);
        return this.getForUpdateString(lockOptions);
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString();
    }

    public String getForUpdateSkipLockedString() {
        return this.getForUpdateString();
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases);
    }

    public String getForUpdateSkipLockedString(String aliases) {
        return this.getForUpdateString(aliases);
    }

    @Deprecated
    public String appendLockHint(LockMode mode, String tableName) {
        return this.appendLockHint(new LockOptions(mode), tableName);
    }

    public String appendLockHint(LockOptions lockOptions, String tableName) {
        return tableName;
    }

    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return sql + new ForUpdateFragment(this, aliasedLockOptions, keyColumnNames).toFragmentString();
    }

    public String getCreateTableString() {
        return "create table";
    }

    public String getAlterTableString(String tableName) {
        StringBuilder sb = new StringBuilder("alter table ");
        if (this.supportsIfExistsAfterAlterTable()) {
            sb.append("if exists ");
        }
        sb.append(tableName);
        return sb.toString();
    }

    public String getCreateMultisetTableString() {
        return this.getCreateTableString();
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        if (entityDescriptor.getIdentifierMapping() instanceof CompositeIdentifierMapping && !this.supportsTuplesInSubqueries()) {
            return new InlineStrategy(this);
        }
        return new PersistentTableStrategy(new IdTable(entityDescriptor, name -> name), AfterUseAction.CLEAN, PhysicalIdTableExporter::new, runtimeModelCreationContext.getSessionFactory());
    }

    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    @Deprecated
    public boolean supportsCurrentTimestampSelection() {
        return false;
    }

    @Deprecated
    public boolean isCurrentTimestampSelectStringCallable() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    @Deprecated
    public String getCurrentTimestampSelectString() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    @Deprecated
    public String getCurrentTimestampSQLFunctionName() {
        return "current_timestamp";
    }

    @Deprecated
    public SQLExceptionConverter buildSQLExceptionConverter() {
        return null;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return null;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public String getSelectClauseNullString(int sqlType) {
        return "null";
    }

    public boolean supportsUnionAll() {
        return false;
    }

    @Deprecated
    public JoinFragment createOuterJoinFragment() {
        return new ANSIJoinFragment();
    }

    @Deprecated
    public CaseFragment createCaseFragment() {
        return new ANSICaseFragment();
    }

    public CaseExpressionWalker getCaseExpressionWalker() {
        return ANSICaseExpressionWalker.INSTANCE;
    }

    public String getNoColumnsInsertString() {
        return "values ( )";
    }

    public boolean supportsNoColumnsInsert() {
        return true;
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public String getCaseInsensitiveLike() {
        return "like";
    }

    public boolean supportsCaseInsensitiveLike() {
        return false;
    }

    public String transformSelectString(String select) {
        return select;
    }

    public int getMaxAliasLength() {
        return 10;
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : NO_BATCH;
    }

    protected void registerKeyword(String word) {
        this.sqlKeywords.add(word.toLowerCase(Locale.ROOT));
    }

    @Deprecated
    public Set<String> getKeywords() {
        return this.sqlKeywords;
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.applyIdentifierCasing(dbMetaData);
        builder.applyReservedWords(dbMetaData);
        builder.applyReservedWords(AnsiSqlKeywords.INSTANCE.sql2003());
        builder.applyReservedWords(this.sqlKeywords);
        builder.setNameQualifierSupport(this.getNameQualifierSupport());
        return builder.build();
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public final String quote(String name) {
        if (name == null) {
            return null;
        }
        if (name.charAt(0) == '`') {
            return this.openQuote() + name.substring(1, name.length() - 1) + this.closeQuote();
        }
        return name;
    }

    public Exporter<Table> getTableExporter() {
        return this.tableExporter;
    }

    public Exporter<Sequence> getSequenceExporter() {
        return this.sequenceExporter;
    }

    public Exporter<Index> getIndexExporter() {
        return this.indexExporter;
    }

    public Exporter<ForeignKey> getForeignKeyExporter() {
        return this.foreignKeyExporter;
    }

    public Exporter<Constraint> getUniqueKeyExporter() {
        return this.uniqueKeyExporter;
    }

    public Exporter<AuxiliaryDatabaseObject> getAuxiliaryDatabaseObjectExporter() {
        return this.auxiliaryObjectExporter;
    }

    public boolean canCreateCatalog() {
        return false;
    }

    public String[] getCreateCatalogCommand(String catalogName) {
        throw new UnsupportedOperationException("No create catalog syntax supported by " + this.getClass().getName());
    }

    public String[] getDropCatalogCommand(String catalogName) {
        throw new UnsupportedOperationException("No drop catalog syntax supported by " + this.getClass().getName());
    }

    public boolean canCreateSchema() {
        return true;
    }

    public String[] getCreateSchemaCommand(String schemaName) {
        return new String[]{"create schema " + schemaName};
    }

    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{"drop schema " + schemaName};
    }

    public String getCurrentSchemaCommand() {
        return null;
    }

    public SchemaNameResolver getSchemaNameResolver() {
        return DefaultSchemaNameResolver.INSTANCE;
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getAddColumnSuffixString() {
        return "";
    }

    public String getDropForeignKeyString() {
        return " drop constraint ";
    }

    public String getTableTypeString() {
        return "";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuilder res = new StringBuilder(30);
        res.append(" add constraint ").append(this.quote(constraintName)).append(" foreign key (").append(String.join((CharSequence)", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            res.append(" (").append(String.join((CharSequence)", ", primaryKey)).append(')');
        }
        return res.toString();
    }

    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        return " add constraint " + this.quote(constraintName) + " " + foreignKeyDefinition;
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint " + constraintName + " primary key ";
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return false;
    }

    public String getNullColumnString() {
        return "";
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public String getTableComment(String comment) {
        return "";
    }

    public String getColumnComment(String comment) {
        return "";
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsIfExistsBeforeConstraintName() {
        return false;
    }

    public boolean supportsIfExistsAfterConstraintName() {
        return false;
    }

    public boolean supportsIfExistsAfterAlterTable() {
        return false;
    }

    public String getDropTableString(String tableName) {
        StringBuilder buf = new StringBuilder("drop table ");
        if (this.supportsIfExistsBeforeTableName()) {
            buf.append("if exists ");
        }
        buf.append(tableName).append(this.getCascadeConstraintsString());
        if (this.supportsIfExistsAfterTableName()) {
            buf.append(" if exists");
        }
        return buf.toString();
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public String getCrossJoinSeparator() {
        return " cross join ";
    }

    public String getTableAliasSeparator() {
        return " as ";
    }

    public ColumnAliasExtractor getColumnAliasExtractor() {
        return ColumnAliasExtractor.COLUMN_LABEL_EXTRACTOR;
    }

    public boolean supportsEmptyInList() {
        return true;
    }

    public boolean areStringComparisonsCaseInsensitive() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return true;
    }

    public boolean supportsParametersInInsertSelect() {
        return true;
    }

    public boolean replaceResultVariableInOrderByClauseWithPosition() {
        return false;
    }

    public String renderOrderByElement(String expression, String collation, String order, NullPrecedence nulls) {
        StringBuilder orderByElement = new StringBuilder(expression);
        if (collation != null) {
            orderByElement.append(" ").append(collation);
        }
        if (order != null) {
            orderByElement.append(" ").append(order);
        }
        if (nulls != NullPrecedence.NONE) {
            orderByElement.append(" nulls ").append(nulls.name().toLowerCase(Locale.ROOT));
        }
        return orderByElement.toString();
    }

    public boolean requiresCastingOfParametersInSelectClause() {
        return false;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return true;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return true;
    }

    public boolean supportsSubselectAsInPredicateLHS() {
        return true;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsLobValueChangePropagation() {
        return true;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return true;
    }

    public boolean supportsSubqueryOnMutatingTable() {
        return true;
    }

    public boolean supportsExistsInSelect() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    public boolean supportsBindAsCallableArgument() {
        return true;
    }

    public boolean supportsTupleCounts() {
        return false;
    }

    public boolean supportsTupleDistinctCounts() {
        return true;
    }

    public boolean requiresParensForTupleDistinctCounts() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return 0;
    }

    public boolean forceLobAsLastValue() {
        return false;
    }

    public boolean isEmptyStringTreatedAsNull() {
        return false;
    }

    public boolean useFollowOnLocking(String sql, QueryOptions queryOptions) {
        return false;
    }

    public String getNotExpression(String expression) {
        return "not " + expression;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Deprecated
    public boolean supportsUnique() {
        return true;
    }

    @Deprecated
    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    @Deprecated
    public String getAddUniqueConstraintString(String constraintName) {
        return " add constraint " + constraintName + " unique ";
    }

    @Deprecated
    public boolean supportsNotNullUnique() {
        return true;
    }

    public String getQueryHintString(String query, List<String> hintList) {
        String hints = String.join((CharSequence)", ", hintList);
        return StringHelper.isEmpty(hints) ? query : this.getQueryHintString(query, hints);
    }

    public String getQueryHintString(String query, String hints) {
        return query;
    }

    public ScrollMode defaultScrollMode() {
        return ScrollMode.SCROLL_INSENSITIVE;
    }

    public boolean supportsTuplesInSubqueries() {
        return true;
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.NO_REF_CURSOR_INSTANCE;
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return null;
    }

    public BatchLoadSizingStrategy getDefaultBatchLoadSizingStrategy() {
        return this.STANDARD_DEFAULT_BATCH_LOAD_SIZING_STRATEGY;
    }

    public boolean isJdbcLogWarningsEnabledByDefault() {
        return true;
    }

    public void augmentRecognizedTableTypes(List<String> tableTypesList) {
    }

    public boolean supportsPartitionBy() {
        return false;
    }

    public boolean supportsNamedParameters(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData != null && databaseMetaData.supportsNamedParameters();
    }

    public boolean supportsNationalizedTypes() {
        return true;
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return 16;
    }

    public boolean supportsNonQueryWithCTE() {
        return false;
    }

    public boolean supportsValuesList() {
        return false;
    }

    public boolean supportsSkipLocked() {
        return false;
    }

    public boolean supportsNoWait() {
        return false;
    }

    public String inlineLiteral(String literal) {
        return String.format("'%s'", this.escapeLiteral(literal));
    }

    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return true;
    }

    protected String escapeLiteral(String literal) {
        return literal.replace("'", "''");
    }

    public String addSqlHintOrComment(String sql, boolean commentsEnabled) {
        return sql;
    }

    protected String prependComment(String sql, String comment) {
        return "/* " + comment + " */ " + sql;
    }

    public HqlTranslator getHqlTranslator() {
        return null;
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return null;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return null;
    }

    public boolean supportsSelectAliasInGroupByClause() {
        return false;
    }

    public DefaultSizeStrategy getDefaultSizeStrategy() {
        return this.defaultSizeStrategy;
    }

    public void setDefaultSizeStrategy(DefaultSizeStrategy defaultSizeStrategy) {
        this.defaultSizeStrategy = defaultSizeStrategy;
    }

    public long getDefaultLobLength() {
        return 0x100000L;
    }

    public int getDefaultDecimalPrecision() {
        return 38;
    }

    public int getDefaultTimestampPrecision() {
        return 6;
    }

    public int getFloatPrecision() {
        return 24;
    }

    public int getDoublePrecision() {
        return 53;
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1L;
    }

    public boolean supportsBitType() {
        return true;
    }

    public String formatBinaryliteral(byte[] bytes) {
        return "X'" + StandardBasicTypes.BINARY.toString(bytes) + "'";
    }

    public String translateDatetimeFormat(String format) {
        return OracleDialect.datetimeFormat(format, true).result();
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "dd";
            }
            case DAY_OF_YEAR: {
                return "dy";
            }
            case DAY_OF_WEEK: {
                return "dw";
            }
            case OFFSET: 
            case NATIVE: 
            case NANOSECOND: 
            case DATE: 
            case TIME: 
            case WEEK_OF_MONTH: 
            case WEEK_OF_YEAR: {
                throw new IllegalArgumentException("illegal field: " + (Object)((Object)unit));
            }
        }
        return unit.toString();
    }

    public String translateDurationField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: 
            case DAY_OF_YEAR: 
            case DAY_OF_WEEK: 
            case OFFSET: 
            case DATE: 
            case TIME: 
            case WEEK_OF_MONTH: 
            case WEEK_OF_YEAR: 
            case TIMEZONE_HOUR: 
            case TIMEZONE_MINUTE: {
                throw new IllegalArgumentException("illegal unit: " + (Object)((Object)unit));
            }
            case NATIVE: {
                return "nanosecond";
            }
        }
        return unit.toString();
    }

    protected String wrapTimestampLiteral(String timestamp) {
        return DateTimeUtils.wrapAsJdbcTimestampLiteral(timestamp);
    }

    protected String wrapDateLiteral(String date) {
        return DateTimeUtils.wrapAsJdbcDateLiteral(date);
    }

    protected String wrapTimeLiteral(String time) {
        return DateTimeUtils.wrapAsJdbcTimeLiteral(time);
    }

    public String formatDateTimeLiteral(TemporalAccessor temporalAccessor, TemporalType precision) {
        switch (precision) {
            case DATE: {
                return this.wrapDateLiteral(DateTimeUtils.formatAsDate(temporalAccessor));
            }
            case TIME: {
                return this.wrapTimeLiteral(DateTimeUtils.formatAsTime(temporalAccessor));
            }
            case TIMESTAMP: {
                return this.wrapTimestampLiteral(this.formatAsTimestamp(temporalAccessor));
            }
        }
        throw new IllegalArgumentException();
    }

    protected String formatAsTimestamp(TemporalAccessor temporalAccessor) {
        return DateTimeUtils.formatAsTimestampWithMicros(temporalAccessor);
    }

    public String formatDateTimeLiteral(Date date, TemporalType precision) {
        switch (precision) {
            case DATE: {
                return this.wrapDateLiteral(DateTimeUtils.formatAsDate(date));
            }
            case TIME: {
                return this.wrapTimeLiteral(DateTimeUtils.formatAsTime(date));
            }
            case TIMESTAMP: {
                return this.wrapTimestampLiteral(this.formatAsTimestamp(date));
            }
        }
        throw new IllegalArgumentException();
    }

    protected String formatAsTimestamp(Date date) {
        return DateTimeUtils.formatAsTimestampWithMicros(date);
    }

    public String formatDateTimeLiteral(Calendar calendar, TemporalType precision) {
        switch (precision) {
            case DATE: {
                return this.wrapDateLiteral(DateTimeUtils.formatAsDate(calendar));
            }
            case TIME: {
                return this.wrapTimeLiteral(DateTimeUtils.formatAsTime(calendar));
            }
            case TIMESTAMP: {
                return this.wrapTimestampLiteral(this.formatAsTimestamp(calendar));
            }
        }
        throw new IllegalArgumentException();
    }

    protected String formatAsTimestamp(Calendar calendar) {
        return DateTimeUtils.formatAsTimestampWithMicros(calendar);
    }

    @Deprecated
    public boolean supportsLimit() {
        return false;
    }

    @Deprecated
    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    @Deprecated
    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    @Deprecated
    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }

    @Deprecated
    public boolean bindLimitParametersFirst() {
        return false;
    }

    @Deprecated
    public boolean useMaxForLimit() {
        return false;
    }

    @Deprecated
    public boolean forceLimitUsage() {
        return false;
    }

    @Deprecated
    public String getLimitString(String query, int offset, int limit) {
        return this.getLimitString(query, offset > 0 || this.forceLimitUsage());
    }

    @Deprecated
    protected String getLimitString(String query, boolean hasOffset) {
        throw new UnsupportedOperationException("Paged queries not supported by " + this.getClass().getName());
    }

    @Deprecated
    public int convertToFirstRowValue(int zeroBasedFirstResult) {
        return zeroBasedFirstResult;
    }

    @Deprecated
    public boolean supportsSequences() {
        return false;
    }

    @Deprecated
    public boolean supportsPooledSequences() {
        return false;
    }

    @Deprecated
    public String getSequenceNextValString(String sequenceName) throws MappingException {
        throw new MappingException("dialect does not support sequences");
    }

    @Deprecated
    public String getSelectSequenceNextValString(String sequenceName) throws MappingException {
        throw new MappingException("dialect does not support sequences");
    }

    @Deprecated
    public String getSequenceNextValString(String sequenceName, int increment) throws MappingException {
        return this.getSequenceNextValString(sequenceName);
    }

    @Deprecated
    public String[] getCreateSequenceStrings(String sequenceName, int initialValue, int incrementSize) throws MappingException {
        return new String[]{this.getCreateSequenceString(sequenceName, initialValue, incrementSize)};
    }

    @Deprecated
    protected String getCreateSequenceString(String sequenceName) throws MappingException {
        return "create sequence " + sequenceName;
    }

    @Deprecated
    protected String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) throws MappingException {
        return this.getCreateSequenceString(sequenceName) + " start with " + initialValue + " increment by " + incrementSize;
    }

    @Deprecated
    public String[] getDropSequenceStrings(String sequenceName) throws MappingException {
        return new String[]{this.getDropSequenceString(sequenceName)};
    }

    @Deprecated
    protected String getDropSequenceString(String sequenceName) throws MappingException {
        return "drop sequence " + sequenceName;
    }

    public class DefaultSizeStrategyImpl
    implements DefaultSizeStrategy {
        @Override
        public Size resolveDefaultSize(SqlTypeDescriptor sqlType, JavaTypeDescriptor javaType) {
            Size size = new Size();
            int jdbcTypeCode = sqlType.getJdbcTypeCode();
            switch (jdbcTypeCode) {
                case -15: 
                case -9: 
                case -7: 
                case -3: 
                case -2: 
                case 1: 
                case 12: {
                    size.setLength(javaType.getDefaultSqlLength(Dialect.this));
                    break;
                }
                case -16: 
                case -4: 
                case -1: {
                    size.setLength(javaType.getLongSqlLength());
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 93: 
                case 2014: {
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this));
                    break;
                }
                case 2: 
                case 3: {
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this));
                    size.setScale(javaType.getDefaultSqlScale());
                    break;
                }
                case 2004: 
                case 2005: {
                    size.setLength(javaType.getDefaultSqlLength(Dialect.this));
                }
            }
            return size;
        }
    }

    public static interface DefaultSizeStrategy {
        public Size resolveDefaultSize(SqlTypeDescriptor var1, JavaTypeDescriptor var2);
    }
}

