/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.FirebirdIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.pagination.SkipFirstLimitHandler;
import org.hibernate.dialect.sequence.FirebirdSequenceSupport;
import org.hibernate.dialect.sequence.InterbaseSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.CastType;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.TempIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorFirebirdDatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceNameExtractorImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;

public class FirebirdDialect
extends Dialect {
    private final int version;
    private static final Pattern FOREIGN_UNIQUE_OR_PRIMARY_KEY_PATTERN = Pattern.compile("violation of .+? constraint \"([^\"]+)\"");
    private static final Pattern CHECK_CONSTRAINT_PATTERN = Pattern.compile("Operation violates CHECK constraint (.+?) on view or table");
    private static final ViolatedConstraintNameExtractor EXTRACTOR = sqle -> {
        String message = sqle.getMessage();
        if (message != null) {
            Matcher foreignUniqueOrPrimaryKeyMatcher = FOREIGN_UNIQUE_OR_PRIMARY_KEY_PATTERN.matcher(message);
            if (foreignUniqueOrPrimaryKeyMatcher.find()) {
                return foreignUniqueOrPrimaryKeyMatcher.group(1);
            }
            Matcher checkConstraintMatcher = CHECK_CONSTRAINT_PATTERN.matcher(message);
            if (checkConstraintMatcher.find()) {
                return checkConstraintMatcher.group(1);
            }
        }
        return null;
    };

    public int getVersion() {
        return this.version;
    }

    public FirebirdDialect() {
        this(250);
    }

    public FirebirdDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    public FirebirdDialect(int version) {
        this.version = version;
        this.registerColumnType(-7, 1L, "smallint");
        this.registerColumnType(-7, "smallint");
        if (this.getVersion() < 300) {
            this.registerColumnType(16, "smallint");
        }
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(93, "timestamp");
        if (this.getVersion() < 400) {
            this.registerColumnType(2014, "timestamp");
        } else {
            this.registerColumnType(2014, "timestamp with time zone");
        }
        this.registerColumnType(12, 8191L, "varchar($l)");
        this.registerColumnType(12, "blob sub_type text");
        this.registerColumnType(-2, 32767L, "char($l) character set octets");
        this.registerColumnType(-2, "blob sub_type binary");
        this.registerColumnType(-3, 32765L, "varchar($l) character set octets");
        this.registerColumnType(-3, "blob sub_type binary");
        this.registerColumnType(2004, "blob sub_type binary");
        this.registerColumnType(2005, "blob sub_type text");
        this.registerColumnType(2011, "blob sub_type text");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.getVersion() < 300 ? -7 : super.getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public String getTypeName(int code, Size size) throws HibernateException {
        return super.getTypeName(code, FirebirdDialect.binaryToDecimalPrecision(code, size));
    }

    @Override
    public int getFloatPrecision() {
        return 21;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.rand(queryEngine);
        CommonFunctionFactory.sinh(queryEngine);
        CommonFunctionFactory.tanh(queryEngine);
        CommonFunctionFactory.cosh(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.bitLength(queryEngine);
        CommonFunctionFactory.substringFromFor(queryEngine);
        CommonFunctionFactory.overlay(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        CommonFunctionFactory.reverse(queryEngine);
        CommonFunctionFactory.bitandorxornot_binAndOrXorNot(queryEngine);
        CommonFunctionFactory.leastGreatest_minMaxValue(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("locate", StandardBasicTypes.INTEGER, "position(?1 in ?2)", "(position(?1 in substring(?2 from ?3)) + (?3) - 1)").setArgumentListSignature("(pattern, string[, start])");
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (to == CastType.BOOLEAN && (from == CastType.LONG || from == CastType.INTEGER)) {
            return "(0<>?1)";
        }
        if (this.getVersion() < 300) {
            if (to == CastType.BOOLEAN && from == CastType.STRING) {
                return "decode(lower(?1),'t',1,'f',0,'true',1,'false',0)";
            }
            if (to == CastType.STRING && from == CastType.BOOLEAN) {
                return "trim(decode(?1,0,'false','true'))";
            }
        } else if (from == CastType.BOOLEAN && (to == CastType.LONG || to == CastType.INTEGER)) {
            return "decode(?1,false,0,true,1)";
        }
        return super.castPattern(from, to);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: 
            case DAY_OF_YEAR: {
                return "(" + super.extractPattern(unit) + "+1)";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        switch (unit) {
            case NATIVE: {
                return "dateadd((?2) millisecond to ?3)";
            }
            case NANOSECOND: {
                return "dateadd((?2)/1e6 millisecond to ?3)";
            }
            case WEEK: {
                return "dateadd((?2)*7 day to ?3)";
            }
            case QUARTER: {
                return "dateadd((?2)*4 month to ?3)";
            }
        }
        return "dateadd(?2 ?1 to ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        switch (unit) {
            case NATIVE: {
                return "datediff(millisecond from ?2 to ?3)";
            }
            case NANOSECOND: {
                return "datediff(millisecond from ?2 to ?3)*1e6";
            }
            case WEEK: {
                return "datediff(day from ?2 to ?3)/7";
            }
            case QUARTER: {
                return "datediff(month from ?2 to ?3)/4";
            }
        }
        return "datediff(?1 from ?2 to ?3)";
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 18;
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public int getMaxAliasLength() {
        return 20;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteKeywords(true);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No create schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No drop schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public boolean supportsCommentOn() {
        return this.getVersion() >= 200;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean requiresCastingOfParametersInSelectClause() {
        return true;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 1500;
    }

    @Override
    public boolean supportsTuplesInSubqueries() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return this.getVersion() >= 300;
    }

    @Override
    public boolean supportsPartitionBy() {
        return this.getVersion() >= 300;
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return this.getVersion() < 300 ? super.toBooleanValueString(bool) : (bool ? "true" : "false");
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion() < 300 ? super.getIdentityColumnSupport() : new FirebirdIdentityColumnSupport();
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        if (this.getVersion() < 200) {
            return InterbaseSequenceSupport.INSTANCE;
        }
        if (this.getVersion() < 300) {
            return FirebirdSequenceSupport.LEGACY_INSTANCE;
        }
        return FirebirdSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getVersion() < 300 ? "select rdb$generator_name from rdb$generators" : "select rdb$generator_name, rdb$initial_value, rdb$generator_increment from rdb$generators";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getVersion() < 300 ? SequenceNameExtractorImpl.INSTANCE : SequenceInformationExtractorFirebirdDatabaseImpl.INSTANCE;
    }

    @Override
    public String getForUpdateString() {
        return " with lock";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.getVersion() < 300 ? SkipFirstLimitHandler.INSTANCE : OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public String getSelectGUIDString() {
        return this.getVersion() < 210 ? super.getSelectGUIDString() : "select uuid_to_char(gen_uuid()) " + this.getFromDual();
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp " + this.getFromDual();
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getFromDual() {
        return "from rdb$database";
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "yearday";
            }
            case DAY_OF_WEEK: {
                return "weekday";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    protected String formatAsTimestamp(Date date) {
        return DateTimeUtils.formatAsTimestampWithMillis(date);
    }

    @Override
    protected String formatAsTimestamp(Calendar calendar) {
        return DateTimeUtils.formatAsTimestampWithMillis(calendar);
    }

    @Override
    protected String formatAsTimestamp(TemporalAccessor temporalAccessor) {
        return DateTimeUtils.formatAsTimestampWithMillis(temporalAccessor);
    }

    @Override
    public String translateDatetimeFormat(String format) {
        throw new NotYetImplementedFor6Exception("format() function not supported on Firebird");
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            String sqlExceptionMessage = sqlException.getMessage();
            switch (errorCode) {
                case 0x14000010: {
                    if (sqlExceptionMessage != null && sqlExceptionMessage.contains("update conflicts with concurrent update")) {
                        return new LockTimeoutException(message, sqlException, sql);
                    }
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 335544345: 
                case 335544510: {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                case 335544474: 
                case 335544475: 
                case 335544476: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 335544466: 
                case 335544558: 
                case 335544665: 
                case 336396758: 
                case 336396991: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            String exceptionMessage = sqlException.getMessage();
            if (exceptionMessage != null && (exceptionMessage.contains("violation of ") || exceptionMessage.contains("violates CHECK constraint"))) {
                String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                return new ConstraintViolationException(message, sqlException, sql, constraintName);
            }
            return null;
        };
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return this.getVersion() < 210 ? super.getFallbackSqmMutationStrategy(entityDescriptor, runtimeModelCreationContext) : new GlobalTemporaryTableStrategy(new IdTable(entityDescriptor, name -> "HT_" + name), () -> new TempIdTableExporter(false, this::getTypeName){

            @Override
            protected String getCreateOptions() {
                return "on commit delete rows";
            }
        }, AfterUseAction.CLEAN, runtimeModelCreationContext.getSessionFactory());
    }
}

