/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.PhysicalIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;

public class HANARowStoreDialect
extends AbstractHANADialect {
    @Override
    public String getCreateTableString() {
        return "create row table";
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableStrategy(new IdTable(entityDescriptor, basename -> "HT_" + basename), () -> new PhysicalIdTableExporter(){

            @Override
            protected String getCreateCommand() {
                return "create global temporary row table";
            }
        }, AfterUseAction.CLEAN, runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    protected boolean supportsAsciiStringTypes() {
        return true;
    }

    @Override
    protected Boolean useUnicodeStringTypesDefault() {
        return Boolean.FALSE;
    }
}

