/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.InformixIdentityColumnSupport;
import org.hibernate.dialect.pagination.FirstLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.SkipFirstLimitHandler;
import org.hibernate.dialect.sequence.InformixSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.InformixUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.TempIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorInformixDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;

public class InformixDialect
extends Dialect {
    private final int version;
    private final UniqueDelegate uniqueDelegate;
    private final LimitHandler limitHandler;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String constraintName;
        switch (JdbcExceptionHelper.extractErrorCode(sqle)) {
            case -268: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Unique constraint (", ") violated.", sqle.getMessage());
                break;
            }
            case -691: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Missing key in referenced table for referential constraint (", ").", sqle.getMessage());
                break;
            }
            case -692: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Key value for constraint (", ") is still being referenced.", sqle.getMessage());
                break;
            }
            default: {
                return null;
            }
        }
        int i = constraintName.indexOf(46);
        if (i != -1) {
            constraintName = constraintName.substring(i + 1);
        }
        return constraintName;
    });

    int getVersion() {
        return this.version;
    }

    public InformixDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion());
    }

    public InformixDialect() {
        this(7);
    }

    public InformixDialect(int version) {
        this.version = version;
        this.registerColumnType(-7, 1L, "boolean");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(-5, "int8");
        this.registerColumnType(92, "datetime hour to second");
        this.registerColumnType(93, "datetime year to fraction($p)");
        this.registerColumnType(2014, "datetime year to fraction($p)");
        this.registerColumnType(-2, "byte");
        this.registerColumnType(-3, "byte");
        this.registerColumnType(12, 255L, "varchar($l)");
        this.registerColumnType(12, 32739L, "lvarchar($l)");
        this.registerColumnType(12, "text");
        this.uniqueDelegate = new InformixUniqueDelegate(this);
        this.limitHandler = this.getVersion() < 10 ? FirstLimitHandler.INSTANCE : new SkipFirstLimitHandler(this.getVersion() >= 11);
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 32;
    }

    @Override
    public int getDefaultTimestampPrecision() {
        return 5;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.instr(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.substring_substr(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.space(queryEngine);
        CommonFunctionFactory.reverse(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.sinh(queryEngine);
        CommonFunctionFactory.tanh(queryEngine);
        CommonFunctionFactory.cosh(queryEngine);
        CommonFunctionFactory.moreHyperbolic(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.initcap(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.ceiling_ceil(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.char_chr(queryEngine);
        CommonFunctionFactory.addMonths(queryEngine);
        CommonFunctionFactory.monthsBetween(queryEngine);
        CommonFunctionFactory.stddev(queryEngine);
        CommonFunctionFactory.variance(queryEngine);
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("locate", StandardBasicTypes.INTEGER, "instr(?2, ?1)", "instr(?2, ?1, ?3)").setArgumentListSignature("(pattern, string[, start])");
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "to_number(to_char(?2,'%S'))";
            }
            case MINUTE: {
                return "to_number(to_char(?2,'%M'))";
            }
            case HOUR: {
                return "to_number(to_char(?2,'%H'))";
            }
            case DAY_OF_WEEK: {
                return "(weekday(?2)+1)";
            }
            case DAY_OF_MONTH: {
                return "day(?2)";
            }
        }
        return "?1(?2)";
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuilder result = new StringBuilder(30).append(" add constraint ").append(" foreign key (").append(String.join((CharSequence)", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            result.append(" (").append(String.join((CharSequence)", ", primaryKey)).append(')');
        }
        result.append(" constraint ").append(constraintName);
        return result.toString();
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        return " add constraint " + foreignKeyDefinition + " constraint " + constraintName;
    }

    @Override
    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint primary key constraint " + constraintName + " ";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return InformixSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select systables.tabname as sequence_name, syssequences.* from syssequences join systables on syssequences.tabid = systables.tabid where tabtype = 'Q'";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorInformixDatabaseImpl.INSTANCE;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public String getFromDual() {
        return "from (select 0 from systables where tabid = 1) as dual";
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select distinct current timestamp from informix.systables";
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableStrategy(new IdTable(rootEntityDescriptor, basename -> "HT_" + basename), () -> new TempIdTableExporter(true, this::getTypeName){

            @Override
            protected String getCreateCommand() {
                return "create temp table";
            }

            @Override
            protected String getCreateOptions() {
                return "with no log";
            }
        }, AfterUseAction.NONE, TempTableDdlTransactionHandling.NONE, runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new InformixIdentityColumnSupport();
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return bool ? "'t'" : "'f'";
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return InformixDialect.datetimeFormat(format).result();
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "").replace("%", "%%").replace("yyyy", "%Y").replace("yyy", "%Y").replace("yy", "%y").replace("y", "Y").replace("MMMM", "%B").replace("MMM", "%b").replace("MM", "%m").replace("M", "%c").replace("EEEE", "%A").replace("EEE", "%a").replace("ee", "%w").replace("e", "%w").replace("dd", "%d").replace("d", "%e").replace("aa", "%p").replace("a", "%p").replace("hh", "%I").replace("HH", "%H").replace("h", "%I").replace("H", "%H").replace("mm", "%M").replace("m", "%M").replace("ss", "%S").replace("s", "%S").replace("SSSSSS", "%F50").replace("SSSSS", "%F5").replace("SSSS", "%F4").replace("SSS", "%F3").replace("SS", "%F2").replace("S", "%F1");
    }
}

