/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleTypesHelper;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.NvlCoalesceEmulation;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.Oracle12cIdentityColumnSupport;
import org.hibernate.dialect.pagination.LegacyOracleLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.OracleSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.CastType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ANSICaseFragment;
import org.hibernate.sql.ANSIJoinFragment;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.OracleJoinFragment;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorOracleDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.sql.BitTypeDescriptor;
import org.hibernate.type.descriptor.sql.BlobTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class OracleDialect
extends Dialect {
    private final int version;
    private static final Pattern DISTINCT_KEYWORD_PATTERN = Pattern.compile("\\bdistinct\\b");
    private static final Pattern GROUP_BY_KEYWORD_PATTERN = Pattern.compile("\\bgroup\\sby\\b");
    private static final Pattern ORDER_BY_KEYWORD_PATTERN = Pattern.compile("\\border\\sby\\b");
    private static final Pattern UNION_KEYWORD_PATTERN = Pattern.compile("\\bunion\\b");
    private static final Pattern SQL_STATEMENT_TYPE_PATTERN = Pattern.compile("^(?:/\\*.*?\\*/)?\\s*(select|insert|update|delete)\\s+.*?");
    private static final int PARAM_LIST_SIZE_LIMIT = 1000;
    public static final String PREFER_LONG_RAW = "hibernate.dialect.oracle.prefer_long_raw";
    private final LimitHandler limitHandler;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        switch (JdbcExceptionHelper.extractErrorCode(sqle)) {
            case 1: 
            case 2291: 
            case 2292: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("(", ")", sqle.getMessage());
            }
            case 1400: {
                return null;
            }
        }
        return null;
    });

    int getVersion() {
        return this.version;
    }

    public OracleDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion());
    }

    public OracleDialect() {
        this(8);
    }

    public OracleDialect(int version) {
        this.version = version;
        this.registerCharacterTypeMappings();
        this.registerNumericTypeMappings();
        this.registerDateTimeTypeMappings();
        this.registerBinaryTypeMappings();
        this.registerReverseHibernateTypeMappings();
        this.registerDefaultProperties();
        this.limitHandler = this.getVersion() < 12 ? new LegacyOracleLimitHandler(this.getVersion()) : OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.cosh(queryEngine);
        CommonFunctionFactory.sinh(queryEngine);
        CommonFunctionFactory.tanh(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.initcap(queryEngine);
        CommonFunctionFactory.instr(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.substring_substr(queryEngine);
        CommonFunctionFactory.leftRight_substr(queryEngine);
        CommonFunctionFactory.translate(queryEngine);
        CommonFunctionFactory.bitand(queryEngine);
        CommonFunctionFactory.lastDay(queryEngine);
        CommonFunctionFactory.toCharNumberDateTimestamp(queryEngine);
        CommonFunctionFactory.ceiling_ceil(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.rownumRowid(queryEngine);
        CommonFunctionFactory.sysdate(queryEngine);
        CommonFunctionFactory.systimestamp(queryEngine);
        CommonFunctionFactory.characterLength_length(queryEngine);
        CommonFunctionFactory.addMonths(queryEngine);
        CommonFunctionFactory.monthsBetween(queryEngine);
        CommonFunctionFactory.everyAny_sumCaseCase(queryEngine);
        CommonFunctionFactory.median(queryEngine);
        CommonFunctionFactory.stddev(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.variance(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        if (this.getVersion() < 9) {
            queryEngine.getSqmFunctionRegistry().register("coalesce", new NvlCoalesceEmulation());
        } else {
            CommonFunctionFactory.coalesce(queryEngine);
        }
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("locate", StandardBasicTypes.INTEGER, "instr(?2, ?1)", "instr(?2, ?1, ?3)").setArgumentListSignature("(pattern, string[, start])");
    }

    @Override
    public String currentDate() {
        return this.getVersion() < 9 ? this.currentTimestamp() : "current_date";
    }

    @Override
    public String currentTime() {
        return this.currentTimestamp();
    }

    @Override
    public String currentTimestamp() {
        return this.getVersion() < 9 ? "sysdate" : this.currentTimestampWithTimeZone();
    }

    @Override
    public String currentLocalTime() {
        return this.currentLocalTimestamp();
    }

    @Override
    public String currentLocalTimestamp() {
        return this.getVersion() < 9 ? this.currentTimestamp() : "localtimestamp";
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return this.getVersion() < 9 ? this.currentTimestamp() : "current_timestamp";
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return "decode(lower(?1),'t',1,'f',0,'true',1,'false',0)";
                    }
                    case LONG: 
                    case INTEGER: {
                        return "abs(sign(?1))";
                    }
                }
            }
            case STRING: {
                switch (from) {
                    case BOOLEAN: {
                        return "decode(?1,0,'false','true')";
                    }
                    case DATE: {
                        return "to_char(?1,'YYYY-MM-DD')";
                    }
                    case TIME: {
                        return "to_char(?1,'HH24:MI:SS')";
                    }
                    case TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
                    }
                    case OFFSET_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
                    }
                    case ZONE_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
                    }
                }
            }
            case DATE: {
                if (from == CastType.STRING) {
                    return "to_date(?1,'YYYY-MM-DD')";
                }
            }
            case TIME: {
                if (from == CastType.STRING) {
                    return "to_date(?1,'HH24:MI:SS')";
                }
            }
            case TIMESTAMP: {
                if (from == CastType.STRING) {
                    return "to_timestamp(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
                }
            }
            case OFFSET_TIMESTAMP: {
                if (from == CastType.STRING) {
                    return "to_timestamp_tz(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
                }
            }
            case ZONE_TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp_tz(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "to_number(to_char(?2,'D'))";
            }
            case DAY_OF_MONTH: {
                return "to_number(to_char(?2,'DD'))";
            }
            case DAY_OF_YEAR: {
                return "to_number(to_char(?2,'DDD'))";
            }
            case WEEK: {
                return "to_number(to_char(?2,'IW'))";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("(?3 + ");
        switch (unit) {
            case YEAR: 
            case QUARTER: 
            case MONTH: {
                pattern.append("numtoyminterval");
                break;
            }
            case WEEK: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("numtodsinterval");
                break;
            }
            default: {
                throw new SemanticException((Object)((Object)unit) + " is not a legal field");
            }
        }
        pattern.append("(");
        switch (unit) {
            case WEEK: 
            case QUARTER: 
            case NANOSECOND: {
                pattern.append("(");
            }
        }
        pattern.append("?2");
        switch (unit) {
            case QUARTER: {
                pattern.append(")*3");
                break;
            }
            case WEEK: {
                pattern.append(")*7");
                break;
            }
            case NANOSECOND: {
                pattern.append(")/1e9");
            }
        }
        pattern.append(",'");
        switch (unit) {
            case QUARTER: {
                pattern.append("month");
                break;
            }
            case WEEK: {
                pattern.append("day");
                break;
            }
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("second");
                break;
            }
            default: {
                pattern.append("?1");
            }
        }
        pattern.append("')");
        pattern.append(")");
        return pattern.toString();
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        StringBuilder pattern = new StringBuilder();
        boolean timestamp = toTimestamp || fromTimestamp;
        switch (unit) {
            case YEAR: {
                this.extractField(pattern, TemporalUnit.YEAR, unit);
                break;
            }
            case QUARTER: 
            case MONTH: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.YEAR, unit);
                pattern.append("+");
                this.extractField(pattern, TemporalUnit.MONTH, unit);
                pattern.append(")");
                break;
            }
            case WEEK: 
            case DAY: {
                this.extractField(pattern, TemporalUnit.DAY, unit);
                break;
            }
            case HOUR: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.DAY, unit);
                if (timestamp) {
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.HOUR, unit);
                }
                pattern.append(")");
                break;
            }
            case MINUTE: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.DAY, unit);
                if (timestamp) {
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.HOUR, unit);
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.MINUTE, unit);
                }
                pattern.append(")");
                break;
            }
            case SECOND: 
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.DAY, unit);
                if (timestamp) {
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.HOUR, unit);
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.MINUTE, unit);
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.SECOND, unit);
                }
                pattern.append(")");
                break;
            }
            default: {
                throw new SemanticException("unrecognized field: " + (Object)((Object)unit));
            }
        }
        return pattern.toString();
    }

    private void extractField(StringBuilder pattern, TemporalUnit unit, TemporalUnit toUnit) {
        pattern.append("extract(");
        pattern.append(this.translateExtractField(unit));
        pattern.append(" from (?3-?2) ");
        switch (unit) {
            case YEAR: 
            case MONTH: {
                pattern.append("year to month");
                break;
            }
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                pattern.append("day to second");
                break;
            }
            default: {
                throw new SemanticException((Object)((Object)unit) + " is not a legal field");
            }
        }
        pattern.append(")");
        pattern.append(unit.conversionFactor(toUnit, this));
    }

    protected void registerCharacterTypeMappings() {
        if (this.getVersion() < 9) {
            this.registerColumnType(12, 4000L, "varchar2($l)");
            this.registerColumnType(12, "clob");
        } else {
            this.registerColumnType(1, "char($l char)");
            this.registerColumnType(12, 4000L, "varchar2($l char)");
            this.registerColumnType(12, "clob");
            this.registerColumnType(-9, 4000L, "nvarchar2($l)");
            this.registerColumnType(-9, "nclob");
        }
    }

    protected void registerNumericTypeMappings() {
        this.registerColumnType(-7, 1L, "number(1,0)");
        this.registerColumnType(-7, "number(3,0)");
        this.registerColumnType(16, "number(1,0)");
        this.registerColumnType(-5, "number(19,0)");
        this.registerColumnType(5, "number(5,0)");
        this.registerColumnType(-6, "number(3,0)");
        this.registerColumnType(4, "number(10,0)");
        this.registerColumnType(2, "number($p,$s)");
        this.registerColumnType(3, "number($p,$s)");
    }

    protected void registerDateTimeTypeMappings() {
        if (this.getVersion() < 9) {
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "date");
            this.registerColumnType(93, "date");
            this.registerColumnType(2014, "date");
        } else {
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "date");
            this.registerColumnType(93, "timestamp($p)");
            this.registerColumnType(2014, "timestamp($p) with time zone");
        }
    }

    protected void registerBinaryTypeMappings() {
        this.registerColumnType(-2, 2000L, "raw($l)");
        this.registerColumnType(-2, "blob");
        this.registerColumnType(-3, 2000L, "raw($l)");
        this.registerColumnType(-3, "blob");
    }

    protected void registerReverseHibernateTypeMappings() {
    }

    protected void registerDefaultProperties() {
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        if (this.getVersion() < 12) {
            this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "false");
            this.getDefaultProperties().setProperty("hibernate.jdbc.batch_versioned_data", "false");
        } else {
            this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "true");
            this.getDefaultProperties().setProperty("hibernate.jdbc.batch_versioned_data", "true");
        }
    }

    @Override
    public boolean supportsBitType() {
        return false;
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        return sqlCode == 16 ? BitTypeDescriptor.INSTANCE : super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        if (this.getVersion() >= 12) {
            boolean preferLong = serviceRegistry.getService(ConfigurationService.class).getSetting(PREFER_LONG_RAW, StandardConverters.BOOLEAN, Boolean.valueOf(false));
            BlobTypeDescriptor descriptor = preferLong ? BlobTypeDescriptor.PRIMITIVE_ARRAY_BINDING : BlobTypeDescriptor.DEFAULT;
            typeContributions.contributeSqlTypeDescriptor(descriptor);
        }
    }

    @Override
    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    @Override
    public String getTableAliasSeparator() {
        return " ";
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion() < 12 ? super.getIdentityColumnSupport() : new Oracle12cIdentityColumnSupport();
    }

    @Override
    public JoinFragment createOuterJoinFragment() {
        return this.getVersion() < 10 ? new OracleJoinFragment() : new ANSIJoinFragment();
    }

    @Override
    public String getCrossJoinSeparator() {
        return this.getVersion() < 10 ? ", " : " cross join ";
    }

    @Override
    public CaseFragment createCaseFragment() {
        return this.getVersion() < 9 ? new DecodeCaseFragment() : new ANSICaseFragment();
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        if (this.getVersion() >= 9) {
            return super.getSelectClauseNullString(sqlType);
        }
        switch (sqlType) {
            case 1: 
            case 12: {
                return "to_char(null)";
            }
            case 91: 
            case 92: 
            case 93: 
            case 2014: {
                return "to_date(null)";
            }
        }
        return "to_number(null)";
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return this.getVersion() < 9 ? "select sysdate from dual" : "select systimestamp from dual";
    }

    @Override
    public String getCurrentTimestampSQLFunctionName() {
        return this.getVersion() < 9 ? "sysdate" : "current_timestamp";
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString() + " of " + aliases + " nowait";
    }

    @Override
    public boolean forUpdateOfColumns() {
        return true;
    }

    @Override
    public String getFromDual() {
        return "from dual";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return OracleSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from user_sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorOracleDatabaseImpl.INSTANCE;
    }

    @Override
    public String getSelectGUIDString() {
        return "select rawtohex(sys_guid()) from dual";
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (JdbcExceptionHelper.extractErrorCode(sqlException)) {
                case 30006: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case 54: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case 4021: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case 60: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 4020: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 1013: {
                    throw new QueryTimeoutException(message, sqlException, sql);
                }
                case 1407: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            return null;
        };
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, OracleTypesHelper.INSTANCE.getOracleCursorTypeSqlType());
        return ++col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 1000;
    }

    @Override
    public boolean forceLobAsLastValue() {
        return true;
    }

    @Override
    public boolean isEmptyStringTreatedAsNull() {
        return true;
    }

    @Override
    public boolean useFollowOnLocking(String sql, QueryOptions queryOptions) {
        if (StringHelper.isEmpty(sql) || queryOptions == null) {
            return true;
        }
        return DISTINCT_KEYWORD_PATTERN.matcher(sql = sql.toLowerCase(Locale.ROOT)).find() || GROUP_BY_KEYWORD_PATTERN.matcher(sql).find() || UNION_KEYWORD_PATTERN.matcher(sql).find() || queryOptions.hasLimit() && (ORDER_BY_KEYWORD_PATTERN.matcher(sql).find() || queryOptions.getLimit().getFirstRow() != null);
    }

    @Override
    public String getNotExpression(String expression) {
        return "not (" + expression + ")";
    }

    @Override
    public String getQueryHintString(String sql, String hints) {
        String statementType = this.statementType(sql);
        int pos = sql.indexOf(statementType);
        if (pos > -1) {
            StringBuilder buffer = new StringBuilder(sql.length() + hints.length() + 8);
            if (pos > 0) {
                buffer.append(sql, 0, pos);
            }
            buffer.append(statementType).append(" /*+ ").append(hints).append(" */").append(sql.substring(pos + statementType.length()));
            sql = buffer.toString();
        }
        return sql;
    }

    @Override
    public int getMaxAliasLength() {
        return 20;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.REF_CURSOR_INSTANCE;
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL";
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    private String statementType(String sql) {
        Matcher matcher = SQL_STATEMENT_TYPE_PATTERN.matcher(sql);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Can't determine SQL statement type for statement: " + sql);
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return this.getVersion() >= 9;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return " for update skip locked";
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.getForUpdateString() + " of " + aliases + " skip locked";
    }

    @Override
    public boolean supportsSkipLocked() {
        return true;
    }

    @Override
    public String getWriteLockString(int timeout) {
        if (this.getVersion() >= 10 && timeout == -2) {
            return this.getForUpdateSkipLockedString();
        }
        if (this.getVersion() >= 9 && timeout == 0) {
            return " for update nowait";
        }
        if (this.getVersion() >= 9 && timeout > 0) {
            float seconds = (float)timeout / 1000.0f;
            return " for update wait " + Math.round(seconds);
        }
        return super.getWriteLockString(timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        if (this.getVersion() >= 10 && timeout == -2) {
            return this.getForUpdateSkipLockedString(aliases);
        }
        return super.getWriteLockString(aliases, timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.getWriteLockString(timeout);
    }

    public static Replacer datetimeFormat(String format, boolean useFm) {
        String fm = useFm ? "fm" : "";
        return new Replacer(format, "'", "\"").replace("GG", "AD").replace("G", "AD").replace("yyyy", "YYYY").replace("yyy", fm + "YYYY").replace("yy", "YY").replace("y", fm + "YYYY").replace("MMMM", fm + "Month").replace("MMM", "Mon").replace("MM", "MM").replace("M", fm + "MM").replace("ww", "IW").replace("w", fm + "IW").replace("YYYY", "IYYY").replace("YYY", fm + "IYYY").replace("YY", "IY").replace("Y", fm + "IYYY").replace("W", "W").replace("EEEE", fm + "Day").replace("EEE", "Dy").replace("ee", "D").replace("e", fm + "D").replace("dd", "DD").replace("d", fm + "DD").replace("DDD", "DDD").replace("DD", fm + "DDD").replace("D", fm + "DDD").replace("aa", "AM").replace("a", "AM").replace("hh", "HH12").replace("HH", "HH24").replace("h", fm + "HH12").replace("H", fm + "HH24").replace("mm", "MI").replace("m", fm + "MI").replace("ss", "SS").replace("s", fm + "SS").replace("SSSSSS", "FF6").replace("SSSSS", "FF5").replace("SSSS", "FF4").replace("SSS", "FF3").replace("SS", "FF2").replace("S", "FF1").replace("zzz", "TZR").replace("zz", "TZR").replace("z", "TZR").replace("ZZZ", "TZHTZM").replace("ZZ", "TZHTZM").replace("Z", "TZHTZM").replace("xxx", "TZH:TZM").replace("xx", "TZHTZM").replace("x", "TZH");
    }

    @Override
    public String formatBinaryliteral(byte[] bytes) {
        return "hextoraw('" + StandardBasicTypes.BINARY.toString(bytes) + "')";
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        return (ResultSet)statement.getObject(position);
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        statement.registerOutParameter(name, OracleTypesHelper.INSTANCE.getOracleCursorTypeSqlType());
        return 1;
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        return (ResultSet)statement.getObject(name);
    }
}

