/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.LockMode;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadUpdateLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteUpdateLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.lock.UpdateLockingStrategy;
import org.hibernate.dialect.pagination.FetchLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.RDMSSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.jboss.logging.Logger;

public class RDMSOS2200Dialect
extends Dialect {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)RDMSOS2200Dialect.class.getName());

    public RDMSOS2200Dialect() {
        LOG.rdmsOs2200Dialect();
        this.registerColumnType(-7, 1L, "smallint");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(16, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(-5, "numeric(19,0)");
        this.registerColumnType(2004, "blob($l)");
        this.registerColumnType(-2, "blob($l)");
        this.registerColumnType(-3, "blob($l)");
        this.registerColumnType(1, "unicode($l)");
        this.registerColumnType(12, "unicode($l)");
        this.registerColumnType(2014, "timestamp($p)");
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 21;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.cosh(queryEngine);
        CommonFunctionFactory.sinh(queryEngine);
        CommonFunctionFactory.tanh(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.rand(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.truncate(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.space(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.initcap(queryEngine);
        CommonFunctionFactory.instr(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.translate(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.dayofweekmonthyear(queryEngine);
        CommonFunctionFactory.weekQuarter(queryEngine);
        CommonFunctionFactory.daynameMonthname(queryEngine);
        CommonFunctionFactory.lastDay(queryEngine);
        CommonFunctionFactory.ceiling_ceil(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.chr_char(queryEngine);
        CommonFunctionFactory.insert(queryEngine);
        CommonFunctionFactory.addMonths(queryEngine);
        CommonFunctionFactory.monthsBetween(queryEngine);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "(second(?2)+microsecond(?2)/1e6)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case DAY_OF_MONTH: {
                return "dayofmonth(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
        }
        return "?1(?2)";
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        switch (unit) {
            case NANOSECOND: {
                return "timestampadd('SQL_TSI_FRAC_SECOND', (?2)/1e3, ?3)";
            }
            case NATIVE: {
                return "timestampadd('SQL_TSI_FRAC_SECOND', ?2, ?3)";
            }
        }
        return "dateadd('?1', ?2, ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        switch (unit) {
            case NANOSECOND: {
                return "timestampdiff('SQL_TSI_FRAC_SECOND', ?2, ?3)*1e3";
            }
            case NATIVE: {
                return "timestampdiff('SQL_TSI_FRAC_SECOND', ?2, ?3)";
            }
        }
        return "dateadd('?1', ?2, ?3)";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public boolean forUpdateOfColumns() {
        return false;
    }

    @Override
    public String getForUpdateString() {
        return "";
    }

    @Override
    public boolean supportsCascadeDelete() {
        return false;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return RDMSSequenceSupport.INSTANCE;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " including contents";
    }

    @Override
    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }

    @Override
    public LimitHandler getLimitHandler() {
        return FetchLimitHandler.INSTANCE;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public String getFromDual() {
        return "from rdms.rdms_dummy where key_col = 1";
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: {
                return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_WRITE: {
                return new PessimisticWriteUpdateLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_READ: {
                return new PessimisticReadUpdateLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC: {
                return new OptimisticLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
        }
        if (lockMode.greaterThan(LockMode.READ)) {
            return new UpdateLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return OracleDialect.datetimeFormat(format, true).replace("SSSSSS", "MLS").replace("SSSSS", "MLS").replace("SSSS", "MLS").replace("SSS", "MLS").replace("SS", "MLS").replace("S", "MLS").result();
    }

    @Override
    public String trimPattern(TrimSpec specification, char character) {
        return AbstractTransactSQLDialect.replaceLtrimRtrim(specification, character);
    }
}

