/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.regex.Pattern;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NullPrecedence;
import org.hibernate.QueryTimeoutException;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.SQLServerIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.SQLServer2005LimitHandler;
import org.hibernate.dialect.pagination.SQLServer2012LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.dialect.sequence.ANSISequenceSupport;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.sql.SmallIntTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class SQLServerDialect
extends AbstractTransactSQLDialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 2100;
    private final int version;
    private static final Pattern OFFSET_PATTERN = Pattern.compile(".*[-+]\\d{2}(:\\d{2})?$");

    int getVersion() {
        return this.version;
    }

    public SQLServerDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion());
    }

    public SQLServerDialect() {
        this(8);
    }

    public SQLServerDialect(int version) {
        this.version = version;
        this.registerColumnType(8, "float");
        if (this.getVersion() >= 10) {
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "datetime2($p)");
            this.registerColumnType(2014, "datetimeoffset($p)");
        }
        this.registerColumnType(12, 8000L, "varchar($l)");
        this.registerColumnType(-9, 4000L, "nvarchar($l)");
        this.registerColumnType(-3, 8000L, "varbinary($l)");
        if (this.getVersion() < 9) {
            this.registerColumnType(-3, "image");
            this.registerColumnType(12, "text");
        } else {
            this.registerColumnType(2004, "varbinary(max)");
            this.registerColumnType(-3, "varbinary(max)");
            this.registerColumnType(2005, "varchar(max)");
            this.registerColumnType(2011, "nvarchar(max)");
            this.registerColumnType(12, "varchar(max)");
            this.registerColumnType(-9, "nvarchar(max)");
        }
        this.registerKeyword("top");
        this.registerKeyword("key");
    }

    @Override
    public long getDefaultLobLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        return sqlCode == -6 ? SmallIntTypeDescriptor.INSTANCE : super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.truncate_round(queryEngine);
        CommonFunctionFactory.everyAny_sumIif(queryEngine);
        if (this.getVersion() >= 10) {
            CommonFunctionFactory.locate_charindex(queryEngine);
            CommonFunctionFactory.stddevPopSamp_stdevp(queryEngine);
            CommonFunctionFactory.varPopSamp_varp(queryEngine);
        }
        if (this.getVersion() >= 11) {
            CommonFunctionFactory.format_format(queryEngine);
            CommonFunctionFactory.translate(queryEngine);
            CommonFunctionFactory.median_percentileCont(queryEngine, true);
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("datefromparts").setInvariantType(StandardBasicTypes.DATE).setExactArgumentCount(3).register();
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("timefromparts").setInvariantType(StandardBasicTypes.TIME).setExactArgumentCount(5).register();
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("smalldatetimefromparts").setInvariantType(StandardBasicTypes.TIMESTAMP).setExactArgumentCount(5).register();
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("datetimefromparts").setInvariantType(StandardBasicTypes.TIMESTAMP).setExactArgumentCount(7).register();
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("datetime2fromparts").setInvariantType(StandardBasicTypes.TIMESTAMP).setExactArgumentCount(8).register();
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("datetimeoffsetfromparts").setInvariantType(StandardBasicTypes.TIMESTAMP).setExactArgumentCount(10).register();
        }
    }

    @Override
    public String currentTimestamp() {
        return "sysdatetime()";
    }

    @Override
    public String currentTime() {
        return this.currentTimestamp();
    }

    @Override
    public String currentDate() {
        return this.currentTimestamp();
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "sysdatetimeoffset()";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public LimitHandler getLimitHandler() {
        if (this.getVersion() >= 11) {
            return SQLServer2012LimitHandler.INSTANCE;
        }
        if (this.getVersion() >= 9) {
            return new SQLServer2005LimitHandler();
        }
        return new TopLimitHandler(false);
    }

    @Override
    public boolean supportsValuesList() {
        return this.getVersion() >= 10;
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "SELECT SCHEMA_NAME()";
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    public String appendLockHint(LockOptions lockOptions, String tableName) {
        if (this.getVersion() >= 9) {
            LockMode lockMode = lockOptions.getAliasSpecificLockMode(tableName);
            if (lockMode == null) {
                lockMode = lockOptions.getLockMode();
            }
            String writeLockStr = lockOptions.getTimeOut() == -2 ? "updlock" : "updlock, holdlock";
            String readLockStr = lockOptions.getTimeOut() == -2 ? "updlock" : "holdlock";
            String noWaitStr = lockOptions.getTimeOut() == 0 ? ", nowait" : "";
            String skipLockStr = lockOptions.getTimeOut() == -2 ? ", readpast" : "";
            switch (lockMode) {
                case UPGRADE: 
                case PESSIMISTIC_WRITE: 
                case WRITE: {
                    return tableName + " with (" + writeLockStr + ", rowlock" + noWaitStr + skipLockStr + ")";
                }
                case PESSIMISTIC_READ: {
                    return tableName + " with (" + readLockStr + ", rowlock" + noWaitStr + skipLockStr + ")";
                }
                case UPGRADE_SKIPLOCKED: {
                    return tableName + " with (updlock, rowlock, readpast" + noWaitStr + ")";
                }
                case UPGRADE_NOWAIT: {
                    return tableName + " with (updlock, holdlock, rowlock, nowait)";
                }
            }
            return tableName;
        }
        switch (lockOptions.getLockMode()) {
            case UPGRADE: 
            case PESSIMISTIC_WRITE: 
            case WRITE: 
            case UPGRADE_NOWAIT: {
                return tableName + " with (updlock, rowlock)";
            }
            case PESSIMISTIC_READ: {
                return tableName + " with (holdlock, rowlock)";
            }
            case UPGRADE_SKIPLOCKED: {
                return tableName + " with (updlock, rowlock, readpast)";
            }
        }
        return tableName;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    @Override
    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 2100;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new SQLServerIdentityColumnSupport();
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return this.getVersion() >= 9;
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getVersion() >= 9;
    }

    @Override
    public boolean supportsNoWait() {
        return this.getVersion() >= 9;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion() < 11 ? NoSequenceSupport.INSTANCE : ANSISequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getVersion() < 11 ? super.getQuerySequencesString() : "select * from INFORMATION_SCHEMA.SEQUENCES";
    }

    @Override
    public String getQueryHintString(String sql, String hints) {
        if (this.getVersion() < 11) {
            return super.getQueryHintString(sql, hints);
        }
        StringBuilder buffer = new StringBuilder(sql.length() + hints.length() + 12);
        int pos = sql.indexOf(";");
        if (pos > -1) {
            buffer.append(sql, 0, pos);
        } else {
            buffer.append(sql);
        }
        buffer.append(" OPTION (").append(hints).append(")");
        if (pos > -1) {
            buffer.append(";");
        }
        sql = buffer.toString();
        return sql;
    }

    @Override
    public String renderOrderByElement(String expression, String collation, String order, NullPrecedence nulls) {
        if (this.getVersion() < 10) {
            return super.renderOrderByElement(expression, collation, order, nulls);
        }
        StringBuilder orderByElement = new StringBuilder();
        if (nulls != null && !NullPrecedence.NONE.equals((Object)nulls)) {
            orderByElement.append("case when ").append(expression).append(" is null then ");
            if (NullPrecedence.FIRST.equals((Object)nulls)) {
                orderByElement.append("0 else 1");
            } else {
                orderByElement.append("1 else 0");
            }
            orderByElement.append(" end, ");
        }
        orderByElement.append(super.renderOrderByElement(expression, collation, order, NullPrecedence.NONE));
        return orderByElement.toString();
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        if (this.getVersion() < 9) {
            return super.buildSQLExceptionConversionDelegate();
        }
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            if ("HY008".equals(sqlState)) {
                throw new QueryTimeoutException(message, sqlException, sql);
            }
            if (1222 == errorCode) {
                throw new LockTimeoutException(message, sqlException, sql);
            }
            return null;
        };
    }

    @Override
    public int getDefaultTimestampPrecision() {
        return 6;
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "(datepart(second,?2,?3)+datepart(nanosecond,?2,?3)/1e9)";
            }
        }
        return "datepart(?1,?2,?3)";
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        switch (unit) {
            case NANOSECOND: {
                return "dateadd(nanosecond, ?2%1000000000, dateadd(second, ?2/1000000000, ?3))";
            }
            case NATIVE: {
                return "dateadd(microsecond, ?2%1000000, dateadd(second, ?2/1000000, ?3))";
            }
        }
        return "dateadd(?1, ?2, ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        switch (unit) {
            case NATIVE: {
                return "datediff_big(microsecond, ?2, ?3)";
            }
        }
        return unit.normalized() == TemporalUnit.NANOSECOND ? "datediff_big(?1, ?2, ?3)" : "datediff(?1, ?2, ?3)";
    }

    @Override
    public String translateDurationField(TemporalUnit unit) {
        switch (unit) {
            case NATIVE: {
                return "microsecond";
            }
        }
        return super.translateDurationField(unit);
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "isowk";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return SQLServerDialect.datetimeFormat(format).result();
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "\"").replace("G", "g").replace("EEEE", "dddd").replace("EEE", "ddd").replace("aa", "tt").replace("a", "tt").replace("S", "F").replace("XXX", "K").replace("xxx", "zzz").replace("x", "zz");
    }

    @Override
    public String formatBinaryliteral(byte[] bytes) {
        return "0x" + StandardBasicTypes.BINARY.toString(bytes);
    }

    @Override
    protected String wrapTimestampLiteral(String timestamp) {
        return OFFSET_PATTERN.matcher(timestamp).matches() ? "cast('" + timestamp + "' as datetimeoffset)" : "cast('" + timestamp + "' as datetime2)";
    }

    @Override
    protected String wrapTimeLiteral(String time) {
        return "cast('" + time + "' as time)";
    }

    @Override
    protected String wrapDateLiteral(String date) {
        return "cast('" + date + "' as date)";
    }
}

