/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.StaleObjectStateException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SpannerDialectTableExporter;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.StandardBasicTypes;

public class SpannerDialect
extends Dialect {
    private final Exporter<Table> spannerTableExporter = new SpannerDialectTableExporter(this);
    private static final LockingStrategy LOCKING_STRATEGY = new DoNothingLockingStrategy();
    private static final EmptyExporter NOOP_EXPORTER = new EmptyExporter();
    private static final UniqueDelegate NOOP_UNIQUE_DELEGATE = new DoNothingUniqueDelegate();

    public SpannerDialect() {
        this.registerColumnType(16, "bool");
        this.registerColumnType(-7, 1L, "bool");
        this.registerColumnType(-7, "int64");
        this.registerColumnType(-6, "int64");
        this.registerColumnType(5, "int64");
        this.registerColumnType(4, "int64");
        this.registerColumnType(-5, "int64");
        this.registerColumnType(7, "float64");
        this.registerColumnType(6, "float64");
        this.registerColumnType(8, "float64");
        this.registerColumnType(3, "float64");
        this.registerColumnType(2, "float64");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(2014, "timestamp");
        this.registerColumnType(92, "timestamp");
        int stringMaxLength = 0x280000;
        int bytesMaxLength = 0xA00000;
        this.registerColumnType(1, 0x280000L, "string($l)");
        this.registerColumnType(12, 0x280000L, "string($l)");
        this.registerColumnType(-15, 0x280000L, "string($l)");
        this.registerColumnType(-9, 0x280000L, "string($l)");
        this.registerColumnType(-2, 0xA00000L, "bytes($l)");
        this.registerColumnType(-3, 0xA00000L, "bytes($l)");
        this.registerColumnType(2005, "string(max)");
        this.registerColumnType(2011, "string(max)");
        this.registerColumnType(2004, "bytes(max)");
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("any_value").setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("array_agg").setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("countif").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("logical_and").setInvariantType(StandardBasicTypes.BOOLEAN).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("logical_or").setInvariantType(StandardBasicTypes.BOOLEAN).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("string_agg").setInvariantType(StandardBasicTypes.STRING).setArgumentCountBetween(1, 2).register();
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.ceiling_ceil(queryEngine);
        CommonFunctionFactory.cosh(queryEngine);
        CommonFunctionFactory.sinh(queryEngine);
        CommonFunctionFactory.tanh(queryEngine);
        CommonFunctionFactory.moreHyperbolic(queryEngine);
        CommonFunctionFactory.bitandorxornot_bitAndOrXorNot(queryEngine);
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("is_inf").setInvariantType(StandardBasicTypes.BOOLEAN).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("is_nan").setInvariantType(StandardBasicTypes.BOOLEAN).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("ieee_divide").setInvariantType(StandardBasicTypes.DOUBLE).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("div").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(2).register();
        CommonFunctionFactory.sha1(queryEngine);
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("farm_fingerprint").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("sha256").setInvariantType(StandardBasicTypes.BINARY).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("sha512").setInvariantType(StandardBasicTypes.BINARY).setExactArgumentCount(1).register();
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.reverse(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.substring_substr(queryEngine);
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("byte_length").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("code_points_to_bytes").setInvariantType(StandardBasicTypes.BINARY).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("code_points_to_string").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("ends_with").setInvariantType(StandardBasicTypes.BOOLEAN).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("from_base64").setInvariantType(StandardBasicTypes.BINARY).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("from_hex").setInvariantType(StandardBasicTypes.BINARY).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("regexp_contains").setInvariantType(StandardBasicTypes.BOOLEAN).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("regexp_extract").setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("regexp_extract_all").setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("regexp_replace").setExactArgumentCount(3).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("safe_convert_bytes_to_string").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("split").setArgumentCountBetween(1, 2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("starts_with").setInvariantType(StandardBasicTypes.BOOLEAN).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("strpos").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("to_base64").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("to_code_points").setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("to_hex").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("json_query").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("json_value").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("array").setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("array_concat").register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("array_length").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("array_to_string").setInvariantType(StandardBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("array_reverse").setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("date").setInvariantType(StandardBasicTypes.DATE).setArgumentCountBetween(1, 3).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("date_add").setInvariantType(StandardBasicTypes.DATE).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("date_sub").setInvariantType(StandardBasicTypes.DATE).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("date_diff").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(3).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("date_trunc").setInvariantType(StandardBasicTypes.DATE).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("date_from_unix_date").setInvariantType(StandardBasicTypes.DATE).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("format_date").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("parse_date").setInvariantType(StandardBasicTypes.DATE).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("unix_date").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("string").setInvariantType(StandardBasicTypes.STRING).setArgumentCountBetween(1, 2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("timestamp").setInvariantType(StandardBasicTypes.TIMESTAMP).setArgumentCountBetween(1, 2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("timestamp_add").setInvariantType(StandardBasicTypes.TIMESTAMP).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("timestamp_sub").setInvariantType(StandardBasicTypes.TIMESTAMP).setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("timestamp_diff").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(3).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("timestamp_trunc").setInvariantType(StandardBasicTypes.TIMESTAMP).setArgumentCountBetween(2, 3).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("format_timestamp").setInvariantType(StandardBasicTypes.STRING).setArgumentCountBetween(2, 3).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("parse_timestamp").setInvariantType(StandardBasicTypes.TIMESTAMP).setArgumentCountBetween(2, 3).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("timestamp_seconds").setInvariantType(StandardBasicTypes.TIMESTAMP).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("timestamp_millis").setInvariantType(StandardBasicTypes.TIMESTAMP).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("timestamp_micros").setInvariantType(StandardBasicTypes.TIMESTAMP).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("unix_seconds").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("unix_millis").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("unix_micros").setInvariantType(StandardBasicTypes.LONG).setExactArgumentCount(1).register();
        queryEngine.getSqmFunctionRegistry().patternDescriptorBuilder("format", "format_timestamp(?2,?1)").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(2).setArgumentListSignature("(datetime as pattern)").register();
    }

    @Override
    public Exporter<Table> getTableExporter() {
        return this.spannerTableExporter;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp() as now";
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return String.valueOf(bool);
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "isoweek";
            }
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_WEEK: {
                return "dayofweek";
            }
            case DAY_OF_YEAR: {
                return "dayofyear";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        if (timestamp) {
            switch (unit) {
                case YEAR: 
                case QUARTER: 
                case MONTH: {
                    throw new SemanticException("illegal unit for timestamp_add(): " + (Object)((Object)unit));
                }
            }
            return "timestamp_add(?3, interval ?2 ?1)";
        }
        switch (unit) {
            case NANOSECOND: 
            case SECOND: 
            case MINUTE: 
            case HOUR: 
            case NATIVE: {
                throw new SemanticException("illegal unit for date_add(): " + (Object)((Object)unit));
            }
        }
        return "date_add(?3, interval ?2 ?1)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        if (toTimestamp || fromTimestamp) {
            switch (unit) {
                case YEAR: 
                case QUARTER: 
                case MONTH: {
                    throw new SemanticException("illegal unit for timestamp_diff(): " + (Object)((Object)unit));
                }
            }
            return "timestamp_diff(?3, ?2, ?1)";
        }
        switch (unit) {
            case NANOSECOND: 
            case SECOND: 
            case MINUTE: 
            case HOUR: 
            case NATIVE: {
                throw new SemanticException("illegal unit for date_diff(): " + (Object)((Object)unit));
            }
        }
        return "date_diff(?3, ?2, ?1)";
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return SpannerDialect.datetimeFormat(format).result();
    }

    public static Replacer datetimeFormat(String format) {
        return MySQLDialect.datetimeFormat(format).replace("EEEE", "%A").replace("EEE", "%a").replace("mm", "%M").replace("m", "%M").replace("MMMM", "%B").replace("MMM", "%b").replace("MM", "%m").replace("M", "%m").replace("ww", "%V").replace("w", "%V").replace("YYYY", "%G").replace("YYY", "%G").replace("YY", "%g").replace("Y", "%g").replace("zzz", "%Z").replace("zz", "%Z").replace("z", "%Z").replace("ZZZ", "%z").replace("ZZ", "%z").replace("Z", "%z").replace("xxx", "%Ez").replace("xx", "%z");
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No create schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No drop schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public String getCurrentSchemaCommand() {
        throw new UnsupportedOperationException("No current schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public SchemaNameResolver getSchemaNameResolver() {
        throw new UnsupportedOperationException("No schema name resolver supported by " + this.getClass().getName());
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getDropForeignKeyString() {
        throw new UnsupportedOperationException("Cannot drop foreign-key constraint because Cloud Spanner does not support foreign keys.");
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        throw new UnsupportedOperationException("Cannot add foreign-key constraint because Cloud Spanner does not support foreign keys.");
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        throw new UnsupportedOperationException("Cannot add foreign-key constraint because Cloud Spanner does not support foreign keys.");
    }

    @Override
    public String getAddPrimaryKeyConstraintString(String constraintName) {
        throw new UnsupportedOperationException("Cannot add primary key constraint in Cloud Spanner.");
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        return LOCKING_STRATEGY;
    }

    @Override
    public String getForUpdateString(LockOptions lockOptions) {
        return "";
    }

    @Override
    public String getForUpdateString() {
        return "";
    }

    @Override
    public String getForUpdateString(String aliases) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getWriteLockString(int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getReadLockString(int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public String getForUpdateNowaitString() {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getForUpdateSkipLockedString() {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public Exporter<Sequence> getSequenceExporter() {
        return NOOP_EXPORTER;
    }

    @Override
    public Exporter<ForeignKey> getForeignKeyExporter() {
        return NOOP_EXPORTER;
    }

    @Override
    public Exporter<Constraint> getUniqueKeyExporter() {
        return NOOP_EXPORTER;
    }

    @Override
    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return sql;
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return NOOP_UNIQUE_DELEGATE;
    }

    @Override
    public boolean supportsUnique() {
        return false;
    }

    @Override
    public boolean supportsNotNullUnique() {
        return false;
    }

    @Override
    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return false;
    }

    @Override
    public String getAddUniqueConstraintString(String constraintName) {
        return "";
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsCascadeDelete() {
        return false;
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public LimitHandler getLimitHandler() {
        return new LimitOffsetLimitHandler();
    }

    @Override
    public String getCastTypeName(SqlExpressable type, Long length, Integer precision, Integer scale) {
        return super.getRawTypeName(type.getJdbcMapping().getSqlTypeDescriptor());
    }

    static class DoNothingUniqueDelegate
    implements UniqueDelegate {
        DoNothingUniqueDelegate() {
        }

        @Override
        public String getColumnDefinitionUniquenessFragment(Column column) {
            return "";
        }

        @Override
        public String getTableCreationUniqueConstraintsFragment(Table table) {
            return "";
        }

        @Override
        public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata) {
            return "";
        }

        @Override
        public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata) {
            return "";
        }
    }

    static class DoNothingLockingStrategy
    implements LockingStrategy {
        DoNothingLockingStrategy() {
        }

        @Override
        public void lock(Object id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, LockingStrategyException {
        }
    }

    static class EmptyExporter<T extends Exportable>
    implements Exporter<T> {
        EmptyExporter() {
        }

        @Override
        public String[] getSqlCreateStrings(T exportable, Metadata metadata) {
            return new String[0];
        }

        @Override
        public String[] getSqlDropStrings(T exportable, Metadata metadata) {
            return new String[0];
        }
    }
}

