/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.type.descriptor.sql.BlobTypeDescriptor;
import org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class SybaseDialect
extends AbstractTransactSQLDialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 250000;

    public SybaseDialect() {
        this.registerColumnType(-5, "numeric(19,0)");
    }

    @Override
    public int getInExpressionCountLimit() {
        return 250000;
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        switch (sqlCode) {
            case 2004: {
                return BlobTypeDescriptor.PRIMITIVE_ARRAY_BINDING;
            }
            case 2005: {
                return ClobTypeDescriptor.STREAM_BINDING_EXTRACTING;
            }
        }
        return super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.locate_charindex(queryEngine);
        CommonFunctionFactory.replace_strReplace(queryEngine);
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select db_name()";
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "calweekofyear";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return "datepart(?1, ?2)";
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        return "dateadd(?1, ?2, ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        return "datediff(?1, ?2, ?3)";
    }
}

