/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockOptions;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedNameImpl;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.Teradata14IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.TempIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.tool.schema.internal.StandardIndexExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.StandardBasicTypes;

public class TeradataDialect
extends Dialect {
    private int version;
    private static final int PARAM_LIST_SIZE_LIMIT = 1024;
    private static ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        int i;
        String constraintName;
        switch (sqle.getErrorCode()) {
            case 27003: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Unique constraint (", ") violated.", sqle.getMessage());
                break;
            }
            case 2700: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Referential constraint", "violation:", sqle.getMessage());
                break;
            }
            case 5317: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Check constraint (", ") violated.", sqle.getMessage());
                break;
            }
            default: {
                return null;
            }
        }
        if (constraintName != null && (i = constraintName.indexOf(46)) != -1) {
            constraintName = constraintName.substring(i + 1);
        }
        return constraintName;
    });

    int getVersion() {
        return this.version;
    }

    public TeradataDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion());
    }

    public TeradataDialect() {
        this(12);
    }

    public TeradataDialect(int version) {
        this.version = version;
        this.registerColumnType(16, "byteint");
        this.registerColumnType(-7, 1L, "byteint");
        this.registerColumnType(-7, "byteint");
        this.registerColumnType(-6, "byteint");
        this.registerColumnType(-2, "byte($l)");
        this.registerColumnType(-3, "varbyte($l)");
        if (this.getVersion() < 13) {
            this.registerColumnType(-5, "numeric(19,0)");
        } else {
            this.registerColumnType(-5, "bigint");
        }
        this.registerKeyword("password");
        this.registerKeyword("type");
        this.registerKeyword("title");
        this.registerKeyword("year");
        this.registerKeyword("month");
        this.registerKeyword("summary");
        this.registerKeyword("alias");
        this.registerKeyword("value");
        this.registerKeyword("first");
        this.registerKeyword("role");
        this.registerKeyword("account");
        this.registerKeyword("class");
        if (this.getVersion() < 14) {
            this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "false");
            this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
        } else {
            this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
            this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        }
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return this.getVersion() < 14 ? 18 : 38;
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("cast((?3 - ?2) ");
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("second");
                break;
            }
            case WEEK: {
                pattern.append("day");
                break;
            }
            case QUARTER: {
                pattern.append("month");
                break;
            }
            default: {
                pattern.append("?1");
            }
        }
        pattern.append("(4) as bigint)");
        switch (unit) {
            case WEEK: {
                pattern.append("/7");
                break;
            }
            case QUARTER: {
                pattern.append("/3");
                break;
            }
            case NANOSECOND: {
                pattern.append("*1e9");
            }
        }
        return pattern.toString();
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        switch (unit) {
            case NANOSECOND: {
                return "(?3 + (?2)/1e9 * interval '1' second)";
            }
            case NATIVE: {
                return "(?3 + (?2) * interval '1' second)";
            }
            case QUARTER: {
                return "(?3 + (?2) * interval '3' month)";
            }
            case WEEK: {
                return "(?3 + (?2) * interval '7' day)";
            }
        }
        return "(?3 + (?2) * interval '1' ?1)";
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.moreHyperbolic(queryEngine);
        CommonFunctionFactory.instr(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.substring_substr(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        queryEngine.getSqmFunctionRegistry().patternDescriptorBuilder("mod", "(?1 mod ?2)").setInvariantType(StandardBasicTypes.STRING).setExactArgumentCount(2).register();
        if (this.getVersion() >= 14) {
            CommonFunctionFactory.lastDay(queryEngine);
            CommonFunctionFactory.initcap(queryEngine);
            CommonFunctionFactory.trim2(queryEngine);
            CommonFunctionFactory.soundex(queryEngine);
            CommonFunctionFactory.ascii(queryEngine);
            CommonFunctionFactory.char_chr(queryEngine);
            CommonFunctionFactory.trunc(queryEngine);
            CommonFunctionFactory.moreHyperbolic(queryEngine);
            CommonFunctionFactory.monthsBetween(queryEngine);
            CommonFunctionFactory.addMonths(queryEngine);
            CommonFunctionFactory.stddevPopSamp(queryEngine);
            CommonFunctionFactory.varPopSamp(queryEngine);
        }
    }

    @Override
    public String getForUpdateString() {
        return "";
    }

    @Override
    public String getAddColumnString() {
        return this.getVersion() < 14 ? super.getAddColumnString() : "add";
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableStrategy(new IdTable(rootEntityDescriptor, basename -> "HT_" + basename), () -> new TempIdTableExporter(false, this::getTypeName){

            @Override
            public String getCreateOptions() {
                return "on commit preserve rows";
            }
        }, AfterUseAction.CLEAN, runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public boolean supportsCascadeDelete() {
        return false;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean areStringComparisonsCaseInsensitive() {
        return this.getVersion() < 14;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        String v = "null";
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                v = "cast(null as decimal)";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                v = "cast(null as varchar(255))";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2014: {
                v = "cast(null as timestamp)";
                break;
            }
        }
        return v;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public String getCreateMultisetTableString() {
        return "create multiset table ";
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    @Override
    public boolean supportsBindAsCallableArgument() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 1024;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, 2006);
        return ++col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement cs) throws SQLException {
        boolean isResultSet = cs.execute();
        while (!isResultSet && cs.getUpdateCount() != -1) {
            isResultSet = cs.getMoreResults();
        }
        return cs.getResultSet();
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return this.getVersion() < 14 ? super.getViolatedConstraintNameExtractor() : EXTRACTOR;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public boolean useFollowOnLocking(String sql, QueryOptions queryOptions) {
        return this.getVersion() >= 14;
    }

    @Override
    public String getWriteLockString(int timeout) {
        if (this.getVersion() < 14) {
            return super.getWriteLockString(timeout);
        }
        String sMsg = " Locking row for write ";
        if (timeout == 0) {
            return sMsg + " nowait ";
        }
        return sMsg;
    }

    @Override
    public String getReadLockString(int timeout) {
        if (this.getVersion() < 14) {
            return super.getReadLockString(timeout);
        }
        String sMsg = " Locking row for read  ";
        if (timeout == 0) {
            return sMsg + " nowait ";
        }
        return sMsg;
    }

    @Override
    public Exporter<Index> getIndexExporter() {
        return new TeradataIndexExporter(this);
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion() < 14 ? super.getIdentityColumnSupport() : new Teradata14IdentityColumnSupport();
    }

    @Override
    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return this.getVersion() < 14 ? super.applyLocksToSql(sql, aliasedLockOptions, keyColumnNames) : new ForUpdateFragment(this, aliasedLockOptions, keyColumnNames).toFragmentString() + " " + sql;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return TopLimitHandler.INSTANCE;
    }

    private static class TeradataIndexExporter
    extends StandardIndexExporter
    implements Exporter<Index> {
        private TeradataIndexExporter(Dialect dialect) {
            super(dialect);
        }

        @Override
        public String[] getSqlCreateStrings(Index index, Metadata metadata) {
            JdbcEnvironment jdbcEnvironment = metadata.getDatabase().getJdbcEnvironment();
            QualifiedTableName qualifiedTableName = index.getTable().getQualifiedTableName();
            String tableName = jdbcEnvironment.getQualifiedObjectNameFormatter().format(qualifiedTableName, jdbcEnvironment.getDialect());
            String indexNameForCreation = Dialect.getDialect().qualifyIndexName() ? jdbcEnvironment.getQualifiedObjectNameFormatter().format(new QualifiedNameImpl(qualifiedTableName.getCatalogName(), qualifiedTableName.getSchemaName(), Identifier.toIdentifier(index.getName())), jdbcEnvironment.getDialect()) : index.getName();
            StringBuilder columnList = new StringBuilder();
            boolean first = true;
            Iterator<Column> column = index.getColumnIterator();
            while (column.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    columnList.append(", ");
                }
                columnList.append(column.next().getName());
            }
            return new String[]{"create index " + indexNameForCreation + "(" + columnList + ") on " + tableName};
        }
    }
}

