/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadUpdateLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteUpdateLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.lock.UpdateLockingStrategy;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TimesTenLimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.sequence.TimesTenSequenceSupport;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.TempIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorTimesTenDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;

public class TimesTenDialect
extends Dialect {
    public TimesTenDialect() {
        this.registerColumnType(-7, 1L, "tt_tinyint");
        this.registerColumnType(-7, "tt_tinyint");
        this.registerColumnType(16, "tt_tinyint");
        this.registerColumnType(-6, "tt_tinyint");
        this.registerColumnType(5, "tt_smallint");
        this.registerColumnType(4, "tt_integer");
        this.registerColumnType(-5, "tt_bigint");
        this.registerColumnType(2, "number($p,$s)");
        this.registerColumnType(3, "number($p,$s)");
        this.registerColumnType(12, "varchar2($l)");
        this.registerColumnType(-9, "nvarchar2($l)");
        this.registerColumnType(91, "tt_date");
        this.registerColumnType(92, "tt_time");
        this.registerColumnType(2014, "timestamp($p)");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 40;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.toCharNumberDateTimestamp(queryEngine);
        CommonFunctionFactory.ceiling_ceil(queryEngine);
        CommonFunctionFactory.instr(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.substring_substr(queryEngine);
        CommonFunctionFactory.leftRight_substr(queryEngine);
        CommonFunctionFactory.char_chr(queryEngine);
        CommonFunctionFactory.rownumRowid(queryEngine);
        CommonFunctionFactory.sysdate(queryEngine);
        CommonFunctionFactory.addMonths(queryEngine);
        CommonFunctionFactory.monthsBetween(queryEngine);
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("locate", StandardBasicTypes.INTEGER, "instr(?2, ?1)", "instr(?2, ?1, ?3)").setArgumentListSignature("(pattern, string[, start])");
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "timestampadd(sql_tsi_frac_second, ?2, ?3)";
            }
        }
        return "timestampadd(sql_tsi_?1, ?2, ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "timestampdiff(sql_tsi_frac_second, ?2, ?3)";
            }
        }
        return "timestampdiff(sql_tsi_?1, ?2, ?3)";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return TimesTenSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select name from sys.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorTimesTenDatabaseImpl.INSTANCE;
    }

    @Override
    public String getCrossJoinSeparator() {
        return ", ";
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }

    @Override
    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    @Override
    public boolean supportsColumnCheck() {
        return false;
    }

    @Override
    public boolean supportsTableCheck() {
        return false;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return TimesTenLimitHandler.INSTANCE;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select sysdate from sys.dual";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableStrategy(new IdTable(rootEntityDescriptor, name -> name.length() > 30 ? name.substring(0, 30) : name), () -> new TempIdTableExporter(false, this::getTypeName){

            @Override
            protected String getCreateOptions() {
                return "on commit delete rows";
            }
        }, AfterUseAction.CLEAN, runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        switch (lockMode) {
            case OPTIMISTIC: {
                return new OptimisticLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_READ: {
                return new PessimisticReadUpdateLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_WRITE: {
                return new PessimisticWriteUpdateLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_FORCE_INCREMENT: {
                return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
        }
        if (lockMode.greaterThan(LockMode.READ)) {
            return new UpdateLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return false;
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        switch (sqlType) {
            case 1: 
            case 12: {
                return "to_char(null)";
            }
            case 91: 
            case 92: 
            case 93: 
            case 2014: {
                return "to_date(null)";
            }
        }
        return "to_number(null)";
    }
}

