/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.internal.util.StringHelper;

public final class TypeNames {
    private final Map<Integer, String> defaults = new HashMap<Integer, String>();
    private final Map<Integer, Map<Long, String>> weighted = new HashMap<Integer, Map<Long, String>>();

    public String get(int typeCode) {
        return this.defaults.get(typeCode);
    }

    public String get(int typeCode, Long size, Integer precision, Integer scale) {
        Map<Long, String> map = this.weighted.get(typeCode);
        if (map != null && map.size() > 0) {
            for (Map.Entry<Long, String> entry : map.entrySet()) {
                if (size > entry.getKey()) continue;
                return TypeNames.replace(entry.getValue(), size, precision, scale);
            }
        }
        return TypeNames.replace(this.get(typeCode), size, precision, scale);
    }

    private static String replace(String type, Long size, Integer precision, Integer scale) {
        if (scale != null) {
            type = StringHelper.replaceOnce(type, "$s", scale.toString());
        }
        if (size != null) {
            type = StringHelper.replaceOnce(type, "$l", size.toString());
        }
        if (precision != null) {
            type = StringHelper.replaceOnce(type, "$p", precision.toString());
        }
        return type;
    }

    public void put(int typeCode, long capacity, String value) {
        this.weighted.computeIfAbsent(typeCode, k -> new TreeMap()).put(capacity, value);
    }

    public void put(int typeCode, String value) {
        this.defaults.put(typeCode, value);
    }

    public boolean containsTypeName(String typeName) {
        return this.defaults.containsValue(typeName);
    }
}

