/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.query.CastType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;

public class CastFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private Dialect dialect;

    public CastFunction(Dialect dialect) {
        super("cast", StandardArgumentsValidators.exactly(2), StandardFunctionReturnTypeResolvers.useArgType(2));
        this.dialect = dialect;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> arguments, SqlAstWalker walker) {
        Expression source = (Expression)arguments.get(0);
        JdbcMapping sourceMapping = ((SqlExpressable)((Object)source.getExpressionType())).getJdbcMapping();
        CastType sourceType = CastType.from(sourceMapping);
        CastTarget castTarget = (CastTarget)arguments.get(1);
        JdbcMapping targetJdbcMapping = castTarget.getExpressionType().getJdbcMapping();
        CastType targetType = CastType.from(targetJdbcMapping);
        String cast = this.dialect.castPattern(sourceType, targetType);
        new PatternRenderer(cast).render(sqlAppender, arguments, walker);
    }

    @Override
    public String getArgumentListSignature() {
        return "(arg as Type)";
    }
}

