/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class ExtractFunction
extends AbstractSqmFunctionDescriptor {
    private Dialect dialect;

    public ExtractFunction(Dialect dialect) {
        super("extract", StandardArgumentsValidators.exactly(2), StandardFunctionReturnTypeResolvers.useArgType(1));
        this.dialect = dialect;
    }

    protected <T> SelfRenderingSqmFunction generateSqmFunctionExpression(List<SqmTypedNode<?>> arguments, AllowableFunctionReturnType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        SqmExtractUnit field = (SqmExtractUnit)arguments.get(0);
        SqmExpression expression = (SqmExpression)arguments.get(1);
        TemporalUnit unit = field.getUnit();
        switch (unit) {
            case NANOSECOND: {
                return this.extractNanoseconds(expression, queryEngine, typeConfiguration);
            }
            case NATIVE: {
                throw new SemanticException("can't extract() the field TemporalUnit.NATIVE");
            }
            case OFFSET: {
                return this.extractOffsetUsingFormat(expression, queryEngine, typeConfiguration);
            }
            case DATE: 
            case TIME: {
                return this.extractDateOrTimeUsingCast(expression, field.getType(), queryEngine, typeConfiguration);
            }
            case WEEK_OF_MONTH: {
                return this.extractWeek(expression, field, TemporalUnit.DAY_OF_MONTH, queryEngine, typeConfiguration);
            }
            case WEEK_OF_YEAR: {
                return this.extractWeek(expression, field, TemporalUnit.DAY_OF_YEAR, queryEngine, typeConfiguration);
            }
        }
        String pattern = this.dialect.extractPattern(unit);
        return queryEngine.getSqmFunctionRegistry().patternDescriptorBuilder("extract", pattern).setExactArgumentCount(2).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).descriptor().generateSqmExpression(arguments, impliedResultType, queryEngine, typeConfiguration);
    }

    private SelfRenderingSqmFunction<Integer> extractWeek(SqmExpression<?> expressionToExtract, SqmExtractUnit<?> field, TemporalUnit dayOf, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        NodeBuilder builder = field.nodeBuilder();
        BasicType intType = typeConfiguration.getBasicTypeForJavaType(Integer.class);
        BasicType floatType = typeConfiguration.getBasicTypeForJavaType(Float.class);
        SqmExtractUnit dayOfUnit = new SqmExtractUnit(dayOf, intType, builder);
        SelfRenderingSqmFunction extractDayOf = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("extract").generateSqmExpression(Arrays.asList(dayOfUnit, expressionToExtract), intType, queryEngine, typeConfiguration);
        SqmExtractUnit dayOfWeekUnit = new SqmExtractUnit(TemporalUnit.DAY_OF_WEEK, intType, builder);
        SelfRenderingSqmFunction extractDayOfWeek = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("extract").generateSqmExpression(Arrays.asList(dayOfWeekUnit, expressionToExtract), intType, queryEngine, typeConfiguration);
        SqmLiteral<Float> seven = new SqmLiteral<Float>(Float.valueOf(7.0f), floatType, builder);
        SqmLiteral<Integer> one = new SqmLiteral<Integer>(1, intType, builder);
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("ceiling").generateSqmExpression(new SqmBinaryArithmetic(BinaryArithmeticOperator.ADD, new SqmBinaryArithmetic(BinaryArithmeticOperator.DIVIDE, new SqmBinaryArithmetic(BinaryArithmeticOperator.SUBTRACT, extractDayOf, extractDayOfWeek, intType, builder), seven, floatType, builder), one, intType, builder), intType, queryEngine, typeConfiguration);
    }

    private SelfRenderingSqmFunction<Long> toLong(SqmExpression<?> arg, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        BasicType longType = typeConfiguration.getBasicTypeForJavaType(Long.class);
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("floor").generateSqmExpression(arg, longType, queryEngine, typeConfiguration);
    }

    private SelfRenderingSqmFunction<Long> extractNanoseconds(SqmExpression<?> expressionToExtract, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        NodeBuilder builder = expressionToExtract.nodeBuilder();
        BasicType floatType = typeConfiguration.getBasicTypeForJavaType(Float.class);
        SqmExtractUnit extractSeconds = new SqmExtractUnit(TemporalUnit.SECOND, floatType, builder);
        SqmLiteral<Float> billion = new SqmLiteral<Float>(Float.valueOf(1.0E9f), floatType, builder);
        return this.toLong(new SqmBinaryArithmetic(BinaryArithmeticOperator.MULTIPLY, this.generateSqmExpression(Arrays.asList(extractSeconds, expressionToExtract), floatType, queryEngine, typeConfiguration), billion, floatType, builder), queryEngine, typeConfiguration);
    }

    private SelfRenderingSqmFunction<ZoneOffset> extractOffsetUsingFormat(SqmExpression<?> expressionToExtract, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        NodeBuilder builder = expressionToExtract.nodeBuilder();
        BasicType offsetType = typeConfiguration.getBasicTypeForJavaType(ZoneOffset.class);
        BasicType stringType = typeConfiguration.getBasicTypeForJavaType(String.class);
        SqmFormat offsetFormat = new SqmFormat("xxx", stringType, builder);
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("format").generateSqmExpression(Arrays.asList(expressionToExtract, offsetFormat), offsetType, queryEngine, typeConfiguration);
    }

    private SelfRenderingSqmFunction<?> extractDateOrTimeUsingCast(SqmExpression<?> expressionToExtract, AllowableFunctionReturnType<?> type, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        NodeBuilder builder = expressionToExtract.nodeBuilder();
        SqmCastTarget target = new SqmCastTarget(type, builder);
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("cast").generateSqmExpression(Arrays.asList(expressionToExtract, target), type, queryEngine, typeConfiguration);
    }

    @Override
    public String getArgumentListSignature() {
        return "(field from arg)";
    }
}

