/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.engine.spi.RowSelection;

public abstract class AbstractNoOffsetLimitHandler
extends AbstractLimitHandler {
    private boolean variableLimit;

    public AbstractNoOffsetLimitHandler(boolean variableLimit) {
        this.variableLimit = variableLimit;
    }

    protected abstract String limitClause();

    protected abstract String insert(String var1, String var2);

    @Override
    public String processSql(String sql, RowSelection selection) {
        if (!AbstractNoOffsetLimitHandler.hasMaxRows(selection)) {
            return sql;
        }
        String limitClause = this.limitClause();
        if (!this.supportsVariableLimit()) {
            String limit = String.valueOf(this.getMaxOrLimit(selection));
            limitClause = limitClause.replace("?", limit);
        }
        return this.insert(limitClause, sql);
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public final boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public final boolean supportsVariableLimit() {
        return this.variableLimit;
    }

    @Override
    public abstract boolean bindLimitParametersFirst();
}

